IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].UFD_EST_PROD_TRIB_UF') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [DBO].UFD_EST_PROD_TRIB_UF
GO 
--   SELECT  * FROM UFD_EST_PROD_TRIB_UF (1,203,4, 90, 6251, 0, 0, 0,1,125.86,0,0,0,0,0,0)
/*
=======================================================================================
'Job.................:  
'Funo..............: 
'Objetivo............: 
'Tabelas.............: 
'Dt Modificao......: 07/05/2021
'Modificao.........: Tag #A001 S calcular VLR_BASE_RET se a nota for  SUBS_TRIB_ANT =1 
					   FARMAGOI-16831 - Novas liminares DIFAL para a UF de SP 
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
CREATE FUNCTION [DBO].UFD_EST_PROD_TRIB_UF  (  @CD_EMP                 INT,
                                            @CD_FILIAL              INT,
                                            @CD_MOV_OP              INT,
                                            @CD_DEST_ORIG           INT,
                                            @CD_PROD                VARCHAR(MAX),
                                            @GERA_DARE              INT,
                                            @TP_MOV                 INT,
                                            @TP_MOV_OP_TRANSA       INT,
                                            @QT_PROD                MONEY,
                                            @VLR_IT                 MONEY,
                                            @PERC_DESC_IT           MONEY,
                                            @PERC_IPI               MONEY,
                                            @VLR_FRETE              MONEY,
                                            @VLR_OUTRAS             MONEY,
                                            @TIPO_OPERACAO          INT,
                                            @ALIQ_ICMS_ENTRADA      MONEY,
											@UF						VARCHAR(10))
/*
DECLARE @CD_EMP INT,
@CD_FILIAL INT,
@CD_MOV_OP INT,
@CD_DEST_ORIG INT,
@CD_PROD VARCHAR(MAX),
@GERA_DARE INT,
@TP_MOV INT,
@TP_MOV_OP_TRANSA INT,
@QT_PROD MONEY,
@VLR_IT MONEY,
@PERC_DESC_IT MONEY,
@PERC_IPI MONEY,
@VLR_FRETE MONEY,
@VLR_OUTRAS MONEY
SET @CD_EMP=1
SET @CD_FILIAL=2
SET @CD_MOV_OP=0
SET @CD_DEST_ORIG=0
SET @CD_PROD=38878
SET @GERA_DARE=0
SET @TP_MOV=0
SET @TP_MOV_OP_TRANSA=1
SET @QT_PROD=0
SET @VLR_IT=0
SET @PERC_DESC_IT=0
SET @PERC_IPI=0
SET @VLR_FRETE=0
SET @VLR_OUTRAS=0
*/
RETURNS @RS_RETURN TABLE(CD_ID                                  INT,    
                            CD_EMP                              INT,
                            CD_PROD                             INT,    
                            CD_CTR                              INT,    
                            CD_TRIB_CST                         INT,
                            UF                                  VARCHAR(2),
                            UF_FILIAL                           VARCHAR(2),
                            TP_MOV                              INT,
                            TP_TRANSA                           INT,
                            TP_LISTA                            INT,
                            DS_TP_LISTA                         VARCHAR(20),
                            NR_NCM                              VARCHAR(50) ,
                            NR_CEST                             VARCHAR(20),
                            CD_CLASS_FISC                       INT,
                            DS_CLASS_FISC                       VARCHAR(200),
                            PERC_RED                            MONEY ,
                            PERC_ICMS                           MONEY,
                            TP_RED_BASE_IMP                     MONEY ,
                            PERC_RED_SUBS_TRIB                  MONEY ,
                            PERC_RED_ESTORNO                    MONEY ,
                            PERC_REPASSE                        MONEY ,
                            PERC_IBPT                           MONEY,
                            TP_GERACAO_DARE                     INT,
                            FLAG_TRIB_DARE                      INT,
                            VLR_PAUTA_IVA                       MONEY,
                            TP_SUBS                             INT,
                            DS_TP_SUBS                          VARCHAR(100),    
                            PERC_ICMS_EST                       MONEY,
                            PERC_ICMS_ORIGEM                    MONEY,
                            HIST                                VARCHAR(500),
                            CD_TRIB                             INT,
                            CD_TRIB_FC                          VARCHAR(5),
                            ICMS                                INT,
                            SUBS_TRIB                           INT,
                            ICMS_RD                             INT,
                            SUBS_TRIB_ANT                       INT,
                            ISENTO                              INT,
                            TIPO_REGIME_EMPRESA                 INT,
                            FLAG_VLR_SUBST_TOTAL_PROD           INT, 
                            FLAG_GERAR_ICMS_SUBS_DARE           INT, 
                            FLAG_OUTROS                         INT,
                            ORIGEM_PRODUTO                      INT,
                            DS_ORIGEM_PRODUTO                   VARCHAR(500),
                            CD_TBL_MVA                          INT,
                            CD_REGIAO_FISCAL                    INT,
                            NM_REGIAO_FISCAL                    VARCHAR(200),
                            VLR_PAUTA_IVA_ORIGINAL              MONEY,
                            MVA_AJUSTADO                        INT,
                            TIPO_TRIBUTACAO_PIS_COFINS          INT,
                            SIGLA_EXCECAO_PIS_COFINS            VARCHAR(10),
                            FLAG_EXCECAO_PIS_COFINS             INT,
                            PIS_COFINS                          INT,
                            FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP INT,
                            FLAG_TRIB_PIS_COFINS_PROD           INT,
                            CTR_PMC                             INT,
                            FLAG_GERAR_ICMS_RETIDO              INT,
                            PERC_RED_IMPORTADO                  MONEY,
                            PERC_RED_SUBS_TRIB_IMPORTADO        MONEY,
                            TIPO_REGIME_EMPRESA_GRUPO_TRIB      INT,
                            DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB   VARCHAR(100),
                            TIPO_REGIME_DESTINATARIO_ORIGEM     INT,
                            DS_TIPO_REGIME_DESTINATARIO_ORIGEM  VARCHAR(100),
                            OBS_GRUPO_TRIB_NF                   VARCHAR(200),
                            EXCECAO_MVA_PRODUTO                 INT,
                            MODALI_BASE_ICMS_SUBST              INT,
                            DS_MODALI_BASE_ICMS_SUBST           VARCHAR(200),
                            PRECO_BASE_SUBS                     INT,
                            PERC_REDU_PMC_FORN                  MONEY,
                            TIPO_REGIME_FILIAL                  INT,
                            DS_TIPO_REGIME_FILIAL               VARCHAR(200),
                            TRIBUTACAO_FORNECEDOR               VARCHAR(3),
                            VLR_PMC                             MONEY,
                            VLR_ICMS_SUBS_GARANTIR              MONEY,
                            PERC_ICMS_DESTINO_DIFAL             MONEY,
                            PERC_ICMS_ORIGEM_DIFAL              MONEY, 
                            GERAR_DIFAL                         INT,
                            GERAR_DAR                           INT,
                            CONTRIBUINTE                        INT,
                            FLAG_GERAR_MOV_DARE                 INT,
                            GERAR_SUBS_TRIB                     INT,
                            TP_SUBS_TRIB                        INT,
                            PERC_ALIQ_FECOP                     MONEY,
                            FLAG_FRETE_BASE_ICMS                MONEY,
                            FCOP                                INT,
                            ICMS_DESONERADO                     INT,
                            MOTIVO_DESONERADO_ICMS              INT,
                            VLR_ICMS_DESONERADO                 MONEY,
                            PERC_ICMS_DESONERADO                MONEY,
                            CD_BENEF                            VARCHAR(10) ,
                            QT_PROD                             INT, -- RETORNO APARTIR DOS APPLY
                            VLR_IT                              MONEY,
                            VLR_DESC_IT                         MONEY,
                            VLR_FRETE                           MONEY,
                            VLR_OUTROS                          MONEY,
                            VLR_IPI                             MONEY,
                            VLR_BASE_ICMS                       MONEY,
                            VLR_ICMS                            MONEY,    
                            VLR_BASE_SUBS                       MONEY,    
                            VLR_ICMS_SUBS                       MONEY,
                            VLR_BASE_ICMS_OP                    MONEY,
                            VLR_ICMS_OP                         MONEY,
                            VLR_BASE_RET                        MONEY,
                            VLR_ICMS_RET                        MONEY,
                            VLR_CUSTO                           MONEY,
                            VLR_REA                             MONEY,
                            VLR_BASE_FECOP                      MONEY,
                            VLR_BASE_FECOP_SUBS                 MONEY,
                            VLR_BASE_FECOP_RET                  MONEY,
                            VLR_FECOP                           MONEY,
                            VLR_FECOP_ST                        MONEY,
                            VLR_FECOP_RET                       MONEY    ,
                            CD_NT_OP                            INT,
                            CD_NT_OP_FC                         VARCHAR(10),
                            CST_PIS                             INT,
                            PERC_PIS                            MONEY,
                            VLR_BASE_PIS                        MONEY,
                            VLR_PIS                             MONEY,
                            CST_COFINS                          INT,
                            PERC_COFINS                         MONEY,
                            VLR_BASE_COFINS                     MONEY,
                            VLR_COFINS                          MONEY,
                            MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS    INT,
                            PROD_PIS_COFINS                     INT,
                            PROD_TIPO_TRIBUTACAO_PIS_COFINS     INT,
                            PROD_FLAG_TRIB_PIS_COFINS_PROD      INT,
                            PROD_LISTA_PROD                     INT,
                            NT_OP_CST                           INT, 
                            CST_TP_TRIB_PIS                     INT,
                            CST_TP_TRIB_COFINS                  INT,
                            PERC_DIFERIMENTO                    MONEY,
							VLR_DIFERIMENTO                     MONEY)
AS
BEGIN
        DECLARE @FILIAL_OPTANTE_SIMPLES_NACIONAL       INT 
        DECLARE @PERC_ALIQ_ICMS_IMPORTACAO             VARCHAR(10)
        DECLARE @TP_FILIAL                             INT        
        DECLARE @DEST_ORIG                             INT        
        DECLARE @FLAG_GERAR_ICMS_RETIDO                INT
        DECLARE @FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO INT
        DECLARE @CD_OPER_MVA							INT
        DECLARE @UF_FILIAL								VARCHAR(2)
        DECLARE @UF_DEST_ORIG							VARCHAR(2)
        DECLARE @CD_REGIAO_FISCAL						INT
        DECLARE @NM_REGIAO_FISCAL						VARCHAR(200)
        DECLARE @FLAG_GERAR_IMPOSTO_RETIDO				INT
        DECLARE @ALIQ_ICMS_UF_DEST						MONEY
        DECLARE @PERCPIS								MONEY
        DECLARE @PERCCOFINS								MONEY
        DECLARE @FLAG_FORN_MICRO_EMPRESA				INT
        DECLARE @PERC_REDU_BASE_PMC						MONEY
        DECLARE @PRECO_BASE_SUBS						INT
        DECLARE @VLR_BASE_IMPOSTO						MONEY
        DECLARE @VLR_PRODUTO_TOTAL						MONEY
        DECLARE @VLR_PRODUTO_IPI						MONEY
        DECLARE @VLR_DESC_IT							MONEY        
        DECLARE @TP_SUBS_SIMULADO						INT
        DECLARE @FLAG_GERA_DARE_SIMULADO				INT    
        DECLARE @FLAG_NF_CPL							INT
        DECLARE @PRECO_BASE_SUBS_DESCONTO				INT
        DECLARE @CONTRIBUINTE							INT
        DECLARE @FLAG_GERAR_MOV_DARE					INT
        DECLARE @SUBS_TRIB								INT
        DECLARE @TP_SUBS_TRIB							INT
        DECLARE @COD_REG_TRIB							INT
        DECLARE @IPI_VLR_LIQ							INT
        DECLARE @PERC_ALIQ_SN                           MONEY
        DECLARE @FLAG_FRETE_BASE_ICMS                   INT
        DECLARE @FLAG_CONVERTE_CST_SN                   INT
		DECLARE @FLAG_NAO_ABATER_ICMS_DESONERADO		INT = 0
		DECLARE @FLAG_ALIQ_ICMS_CONFIG_PRODUTO			INT = 0
		DECLARE @FLAG_NAO_GERAR_DIFAL					INT = 0

        SET @PRECO_BASE_SUBS_DESCONTO=0
        SET @FLAG_NF_CPL=0
        SET @VLR_PRODUTO_TOTAL = (@QT_PROD*@VLR_IT)  --CALCULANDO TOTAL PRODUTO
        SET @VLR_DESC_IT=0
        SET @CONTRIBUINTE=0
        SET @FLAG_GERAR_MOV_DARE=0
        SET @SUBS_TRIB=0
        SET @TP_SUBS_TRIB=0
        IF ISNULL(@CD_MOV_OP,0) > 0 
            BEGIN 
                SELECT     @DEST_ORIG = DEST_ORIG FROM GLB_MOV_OP WHERE CD_MOV_OP = @CD_MOV_OP
            END
        ELSE
            BEGIN SELECT TOP 1  @DEST_ORIG  = DEST_ORIG FROM GLB_MOV_OP WHERE TP_MOV = @TP_MOV AND TP_MOV_OP_TRANSA = @TP_MOV_OP_TRANSA END
        --SE O DESTINATARIO NAO FOR INFORMADO PEGA O CONSUMIDOR FINAL
        --PARA CONTINUAR COM A TRANSACAO
        IF @CD_DEST_ORIG=0
        BEGIN
            SET @CD_DEST_ORIG= ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'CD_CLI_PADRAO', 1, @CD_FILIAL)),0)
        END
        IF @DEST_ORIG= 1 -- VERIFICA SE O FORNECEDOR CALCULA O VALOR DO IPI SOBRE O VALOR LIQUIDO OU BRUTO DO PRODUTO
            BEGIN
                SET @IPI_VLR_LIQ = ISNULL((SELECT  FLAG_BASE_IPI_VLR_LIQUIDO FROM PG_FORN WHERE CD_FORN = @CD_DEST_ORIG),0)
            END
        ELSE SET @IPI_VLR_LIQ =  0
        IF @PERC_DESC_IT > 0
        BEGIN
            SET @VLR_DESC_IT = ((@VLR_IT*@PERC_DESC_IT)/100.00)
            SET @VLR_PRODUTO_TOTAL = (@QT_PROD*@VLR_IT) - ((@QT_PROD*@VLR_IT)*(@PERC_DESC_IT/100.00))  --CALCULANDO TOTAL PRODUTO
        END
        --SET @VLR_PRODUTO_IPI= @VLR_PRODUTO_TOTAL * (@PERC_IPI/100.00)    --CALCULANDO IPI
        --CALCULANDO IPI
        IF @IPI_VLR_LIQ = 1 -- CALCULO PELO VALOR LIQUIDO
            SET @VLR_PRODUTO_IPI= @VLR_PRODUTO_TOTAL * (@PERC_IPI/100.00)     
        BEGIN
            SET @VLR_PRODUTO_IPI= (@QT_PROD*@VLR_IT) * (@PERC_IPI/100.00) 
        END
        SET @VLR_PRODUTO_IPI= @VLR_PRODUTO_TOTAL * (@PERC_IPI/100.00)    --CALCULANDO IPI
        SET @VLR_BASE_IMPOSTO= @VLR_PRODUTO_TOTAL+@VLR_PRODUTO_IPI+@VLR_FRETE+@VLR_OUTRAS --CALCULANDO BASE DE IMPOSTO
        SET @PERCPIS=ISNULL((SELECT TOP 1  PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 1),0)
        SET @PERCCOFINS = ISNULL((SELECT TOP 1 PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 2),0)
        SET @FLAG_FORN_MICRO_EMPRESA=0
        SET @PERC_REDU_BASE_PMC=0
        SET @PRECO_BASE_SUBS=0
        IF @TP_MOV_OP_TRANSA=0 
             BEGIN
                SET @FLAG_CONVERTE_CST_SN= ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1,  'FLAG_CONVERTE_CST_SIMPLES_NACIONAL_ENTRADA', 0, 0)),0)
             END
        ELSE
            SET @FLAG_CONVERTE_CST_SN = 0
        DECLARE @TBL_TRIB_PROD TABLE (  CD_ID                   INT,    
                                        CD_EMP                  INT,
                                        CD_PROD                 INT,    
                                        CD_CTR                  INT,    
                                        CD_TRIB_CST             INT,
                                        UF                      VARCHAR(2),
                                        UF_FILIAL                VARCHAR(2),
                                        TP_MOV                  INT,
                                        TP_TRANSA               INT,
                                        TP_LISTA                INT,
                                        DS_TP_LISTA                VARCHAR(30),
                                        NR_NCM                  VARCHAR(50),
                                        NR_CEST                 VARCHAR(20),
                                        CD_CLASS_FISC           INT,
                                        DS_CLASS_FISC            VARCHAR(200),
                                        PERC_RED                MONEY ,
                                        PERC_ICMS               MONEY,
                                        TP_RED_BASE_IMP         MONEY ,
                                        PERC_RED_SUBS_TRIB      MONEY ,
                                        PERC_RED_ESTORNO        MONEY ,
                                        PERC_REPASSE            MONEY ,
                                        PERC_IBPT               MONEY,
                                        TP_GERACAO_DARE         INT,
                                        FLAG_TRIB_DARE                INT,
                                        VLR_PAUTA_IVA               MONEY,
                                        TP_SUBS                     INT,
                                        DS_TP_SUBS                VARCHAR(100),
                                        PERC_ICMS_EST               MONEY,
                                        PERC_ICMS_ORIGEM            MONEY,
                                        HIST                        VARCHAR(500),
                                        CD_TRIB                     INT,
                                        CD_TRIB_FC                  VARCHAR(5),
                                        ICMS                        INT,
                                        SUBS_TRIB                   INT,
                                        ICMS_RD                     INT,
                                        SUBS_TRIB_ANT               INT,
                                        ISENTO                      INT,
                                        TIPO_REGIME_EMPRESA         INT,
                                        FLAG_VLR_SUBST_TOTAL_PROD   INT, 
                                        FLAG_GERAR_ICMS_SUBS_DARE   INT, 
                                        FLAG_OUTROS                 INT,
                                        ORIGEM_PRODUTO              INT,
                                        DS_ORIGEM_PRODUTO            VARCHAR(500),
                                        CD_TBL_MVA                  INT,
                                        CD_REGIAO_FISCAL            INT,
                                        NM_REGIAO_FISCAL            VARCHAR(200),
                                        VLR_PAUTA_IVA_ORIGINAL        MONEY,
                                        MVA_AJUSTADO                INT,
                                        TIPO_TRIBUTACAO_PIS_COFINS            INT,
                                        SIGLA_EXCECAO_PIS_COFINS            VARCHAR(10),
                                        FLAG_EXCECAO_PIS_COFINS                INT,
                                        PIS_COFINS                            INT,
                                        FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP    INT,
                                        FLAG_TRIB_PIS_COFINS_PROD            INT,
                                        CTR_PMC                                INT,
                                        FLAG_GERAR_ICMS_RETIDO                INT,
                                        PERC_RED_IMPORTADO                  MONEY,
                                        PERC_RED_SUBS_TRIB_IMPORTADO        MONEY,
                                        TIPO_REGIME_EMPRESA_GRUPO_TRIB      INT,
                                        DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB   VARCHAR(100),
                                        TIPO_REGIME_DESTINATARIO_ORIGEM     INT,
                                        DS_TIPO_REGIME_DESTINATARIO_ORIGEM  VARCHAR(100),
                                        OBS_GRUPO_TRIB_NF                    VARCHAR(200),
                                        EXCECAO_MVA_PRODUTO                    INT,
                                        MODALI_BASE_ICMS_SUBST                INT,
                                        DS_MODALI_BASE_ICMS_SUBST            VARCHAR(200),
                                        PRECO_BASE_SUBS                        INT,
                                        PERC_REDU_PMC_FORN                  MONEY,
                                        TIPO_REGIME_FILIAL                    INT,
                                        DS_TIPO_REGIME_FILIAL                VARCHAR(200),
                                        TRIBUTACAO_FORNECEDOR                VARCHAR(3),
                                        VLR_PMC                                MONEY,
                                        VLR_ICMS_SUBS_GARANTIR                MONEY,
                                        PERC_ICMS_DESTINO_DIFAL                MONEY,
                                        PERC_ICMS_ORIGEM_DIFAL                MONEY,
                                        GERAR_DIFAL                            INT,
                                        GERAR_DARE                            INT,
                                        CONTRIBUINTE                        INT,
                                        FLAG_GERAR_MOV_DARE                    INT,
                                        GERAR_SUBS_TRIB                        INT,
                                        TP_SUBS_TRIB                        INT,
                                        PERC_ALIQ_FECOP                        MONEY,
                                        FLAG_FRETE_BASE_ICMS                INT,
                                        FCOP                                INT,                                        
                                        ICMS_DESONERADO                        INT,
                                        MOTIVO_DESONERADO_ICMS                INT,
                                        VLR_ICMS_DESONERADO                    MONEY,
                                        PERC_ICMS_DESONERADO                MONEY,
                                        CD_BENEF                            VARCHAR(10), 
                                        PERC_DIFERIMENTO                     MONEY, 
										VLR_DIFERIMENTO                      MONEY)
        IF @GERA_DARE > 1        
            BEGIN
                SET @FLAG_GERA_DARE_SIMULADO = ABS((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'FLAG_GERA_DARE_SIMULADO', 1, @CD_FILIAL)));
                IF @FLAG_GERA_DARE_SIMULADO = 1
                    BEGIN                 
                        SET @TP_SUBS_SIMULADO = (CASE WHEN (@GERA_DARE - 10) < 0 THEN 0 ELSE (@GERA_DARE - 10) END)
                        SET @GERA_DARE = 1                
                        --SE GERA DARE SIMULADO SERA CALCULADO O DARE PARA CADA SIMULACAO PASSADA PARA O PARAMETRO @GERA_DARE SENDE ELES:
                        --10 - DARE POR MVA, 11 - DARE POR PAUTA, 12 - DARE POR CARGA TRIBUTARIA, 13 - DARE POR PMC.
                    END
                SET @GERA_DARE = 1
            END
        SET @PERC_ALIQ_ICMS_IMPORTACAO = (SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'PERC_ALIQ_ICMS_IMPORTACAO', 0, 0));
        IF ISNUMERIC(@PERC_ALIQ_ICMS_IMPORTACAO) = 0    
        BEGIN
            SET @PERC_ALIQ_ICMS_IMPORTACAO = 0
        END
        /****************************************************************/
        SET @PERC_ALIQ_SN=0;
		SET @FLAG_ALIQ_ICMS_CONFIG_PRODUTO = 0; 
        --SE FOR ZERADO BUSCA PELO CADASTRO DA FILIAL 
        SELECT 
            @FILIAL_OPTANTE_SIMPLES_NACIONAL= 1,
            @PERC_ALIQ_SN=ISNULL(PERC_ICMS_SIMPLES_NACIONAL,0),
			@FLAG_ALIQ_ICMS_CONFIG_PRODUTO = ISNULL(FLAG_ALIQ_ICMS_CONFIG_PRODUTO,0)
        FROM PRC_FILIAL 
        WHERE 
            CD_EMP=@CD_EMP
            AND CD_FILIAL = @CD_FILIAL 
            AND REGIME_TRIBUTARIO IN (1,2) 
        --BUSCANDO PELO PARAMETRO
        IF @FILIAL_OPTANTE_SIMPLES_NACIONAL=0 
            BEGIN
                SET @FILIAL_OPTANTE_SIMPLES_NACIONAL = (SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'FILIAL_OPTANTE_SIMPLES_NACIONAL', 1, @CD_FILIAL));        
            END
        /****************************************************************/
        SET @CD_REGIAO_FISCAL=0
        SET @NM_REGIAO_FISCAL='NAO DEFINADA'
        SET @FLAG_GERAR_IMPOSTO_RETIDO=0
        SET @FLAG_FRETE_BASE_ICMS=0
        /*
            PRC_REGIAO_FISCAL.FLAG_GERAR_IMPOSTO_RETIDO=>DEFINICAO ABAIXO
            0 - NAO GERA IMPOSTO
            1 - GERAR SUBSTITUIO IMPOSTO RETIDO (060)
            2 - GERAR PRECO SOBRE AGREGADOR REA - CE
        */
        SELECT 
            TOP 1 
            @CD_REGIAO_FISCAL=PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL,  
            @NM_REGIAO_FISCAL=PRC_REGIAO_FISCAL.NM_REGIAO_FISCAL,
            @FLAG_GERAR_IMPOSTO_RETIDO=PRC_REGIAO_FISCAL.FLAG_GERAR_IMPOSTO_RETIDO,
            @FLAG_FRETE_BASE_ICMS=FLAG_FRETE_BASE_ICMS
        FROM 
             PRC_REGIAO_FISCAL_PRC_FILIAL INNER JOIN PRC_REGIAO_FISCAL ON
             PRC_REGIAO_FISCAL_PRC_FILIAL.CD_REGIAO_FISCAL = PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
        WHERE 
            PRC_REGIAO_FISCAL_PRC_FILIAL.CD_EMP = @CD_EMP 
            AND PRC_REGIAO_FISCAL_PRC_FILIAL.CD_FILIAL = @CD_FILIAL;
        IF @NM_REGIAO_FISCAL=''
        BEGIN
            SET @NM_REGIAO_FISCAL='NAO DEFINADA'
            SET @CD_REGIAO_FISCAL=0
            SET @FLAG_GERAR_IMPOSTO_RETIDO=0
            SET @FLAG_FRETE_BASE_ICMS=0
        END
        SET @TP_FILIAL = (SELECT 
                                TOP 1 ISNULL(TP_FILIAL,0) AS TP_FILIAL
                            FROM 
                                PRC_FILIAL 
                            WHERE 
                                CD_EMP            = @CD_EMP
                                AND CD_FILIAL   = @CD_FILIAL);
----------------------------------------------------------------------------------------------------------------
--CAPTURANDO DADOS DA NATUREZA DE OPERACAO
---------------------------------------------------------------------------------------------------------------- 
    IF ISNULL(@CD_MOV_OP,0) > 0 
        BEGIN
            SELECT  
                @CD_MOV_OP                                = CD_MOV_OP,
                @TP_MOV                                 = TP_MOV, 
                @DEST_ORIG                              = DEST_ORIG, 
                @TP_MOV_OP_TRANSA                       = TP_MOV_OP_TRANSA,
                @FLAG_GERAR_ICMS_RETIDO = ISNULL(FLAG_GERAR_ICMS_RETIDO,0),
                @FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO = ISNULL(FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO,0),
                @FLAG_NF_CPL=ISNULL(FLAG_MOV_OP_NFE_CPL,0),
                @FLAG_GERAR_MOV_DARE=ISNULL(FLAG_GERA_DARE,0)
            FROM GLB_MOV_OP
            WHERE 
                CD_MOV_OP = @CD_MOV_OP
        END
    ELSE
        BEGIN
            SELECT TOP 1
                @CD_MOV_OP                                = CD_MOV_OP,
                @TP_MOV                                 = TP_MOV, 
                @DEST_ORIG                              = DEST_ORIG, 
                @TP_MOV_OP_TRANSA                       = TP_MOV_OP_TRANSA,
                @FLAG_GERAR_ICMS_RETIDO = ISNULL(FLAG_GERAR_ICMS_RETIDO,0),
                @FLAG_NF_CPL=ISNULL(FLAG_MOV_OP_NFE_CPL,0),
                @FLAG_GERAR_MOV_DARE=ISNULL(FLAG_GERA_DARE,0)
            FROM 
                GLB_MOV_OP
            WHERE 
                TP_MOV = @TP_MOV
                AND TP_MOV_OP_TRANSA = @TP_MOV_OP_TRANSA
        END
----------------------------------------------------------------------------------------------------------------
--BUSCANDO A UF DA FILIAL
----------------------------------------------------------------------------------------------------------------             
        SET @UF_FILIAL =   (SELECT TOP 1 CID.UF 
                            FROM 
                                PRC_FILIAL F 
                                INNER JOIN GLB_CID CID ON 
                                F.CD_CID = CID.CD_CID
                            WHERE 
                                F.CD_EMP        = @CD_EMP
                                AND F.CD_FILIAL = @CD_FILIAL)
        IF @CD_DEST_ORIG = 0
        BEGIN
            SET @CD_OPER_MVA    = 0
            SET @UF_DEST_ORIG   = @UF_FILIAL
            SET @FLAG_FORN_MICRO_EMPRESA = CASE WHEN @FILIAL_OPTANTE_SIMPLES_NACIONAL=1 THEN 1 ELSE 0 END
        END
        ELSE
        BEGIN
            ----------------------------------------------------------------------------------------------------------------
            --BUSCANDO A UF E TIPO DA OPERACAO DA ORIGEM OU DESTINO
            ----------------------------------------------------------------------------------------------------------------
            IF @DEST_ORIG = 0 
            BEGIN 
                SELECT TOP 1 
                        @CD_OPER_MVA    = ISNULL(D.CD_OPER_MVA,0),
                        @UF_DEST_ORIG   = CID.UF,
                        @FLAG_FORN_MICRO_EMPRESA=0,
                        @CONTRIBUINTE = ISNULL(D.CONTRIBUINTE,0),
                        --TIPO DO GRUPO SO POSSUI DOIS 0 - LUCRO REAL E PRESUMIDO
                        -- 1 - SIMPLES
                        @COD_REG_TRIB = ISNULL(CASE WHEN D.CONTRIBUINTE IN (0,1) THEN 0 ELSE 1 END,0)
                FROM RC_CLI D 
                        INNER JOIN GLB_CID CID ON 
                                D.CD_CID = CID.CD_CID
                WHERE 
                        D.CD_EMP        = @CD_EMP
                        AND D.CD_CLI    = @CD_DEST_ORIG
            END
            IF @DEST_ORIG = 1 
            BEGIN 
                SELECT TOP 1 
                        @CD_OPER_MVA    = ISNULL(D.CD_OPER_MVA,0),
                        @UF_DEST_ORIG   = CID.UF ,
                        @FLAG_FORN_MICRO_EMPRESA= CASE WHEN @TP_MOV_OP_TRANSA= 0 THEN --SO PARA PROCESSO DE ENTRADA
                                                        ISNULL(D.FLAG_FORN_MICRO_EMPRESA,0)
                                                    ELSE
                                                        0
                                                    END,
                        @PERC_REDU_BASE_PMC=ISNULL(PERC_REDU_BASE_PMC,0),
                        @PRECO_BASE_SUBS=ISNULL(PRECO_BASE_SUBS,0),
                        @PRECO_BASE_SUBS_DESCONTO=ISNULL(SUBS_DESC,0),
                        @CONTRIBUINTE = ISNULL(D.CONTRIBUINTE,0),
                        @SUBS_TRIB = ISNULL(D.SUBS_TRIB,0),
                        @TP_SUBS_TRIB = ISNULL(D.TP_SUBS_TRIB,0),
                        --TIPO DO GRUPO SO POSSUI DOIS 0 - LUCRO REAL E PRESUMIDO
                        --                          1 - SIMPLES
                        --JA NO CADASTRO DO FORNECEDOR SAO 4.
                        @COD_REG_TRIB = CASE WHEN @TP_MOV_OP_TRANSA= 0 THEN --SO PARA PROCESSO DE ENTRADA
                                            ISNULL(CASE WHEN D.CRT IN (0,3) THEN 0 ELSE 1 END,0)
                                        ELSE
                                            0
                                        END
						, @FLAG_NAO_ABATER_ICMS_DESONERADO = ISNULL(FLAG_NAO_ABATER_ICMS_DESONERADO,0)
                FROM PG_FORN D 
                        INNER JOIN GLB_CID CID ON 
                        D.CD_CID = CID.CD_CID
                WHERE 
                        D.CD_EMP        = @CD_EMP
                        AND D.CD_FORN   = @CD_DEST_ORIG     
            END
            IF @DEST_ORIG = 2 
            BEGIN 
                SELECT TOP 1 
                    @CD_OPER_MVA    = ISNULL(D.CD_OPER_MVA,0),
                    @UF_DEST_ORIG   = CID.UF,
                    @FLAG_FORN_MICRO_EMPRESA=0,
                    @CONTRIBUINTE = ISNULL(D.CONTRIBUINTE,0),
                    @SUBS_TRIB = 1,
                    @TP_SUBS_TRIB = 1,
                    --TIPO DO GRUPO SO POSSUI DOIS 0 - LUCRO REAL E PRESUMIDO
                    --                          1 - SIMPLES
                    @COD_REG_TRIB = ISNULL(CASE WHEN D.REGIME_TRIBUTARIO IN (0,3,4) THEN 0 ELSE 1 END,0)
                FROM 
                    PRC_FILIAL D 
                    INNER JOIN GLB_CID CID ON 
                    D.CD_CID = CID.CD_CID
                WHERE 
                    D.CD_EMP        = @CD_EMP
                    AND D.CD_FILIAL = @CD_DEST_ORIG         
            END
        END 

		IF NOT COALESCE(@UF,'') = ''
		BEGIN
			SET @UF_DEST_ORIG = @UF;
		END

		--IF EXISTS(SELECT * FROM EST_TRIB_UF_SEM_DIFAL WHERE UF_ORIGEM = @UF_FILIAL AND UF_DESTINO = @UF_DEST_ORIG)
		IF EXISTS(SELECT * FROM EST_TRIB_UF_SEM_DIFAL WHERE CD_FILIAL_ORIG =  @CD_FILIAL AND UF_DESTINO = @UF_DEST_ORIG)
		
		BEGIN
			SET @FLAG_NAO_GERAR_DIFAL = 1
		END

----------------------------------------------------------------------------------------------------------------
--CRIA A TABELA DE PRODUTOS
----------------------------------------------------------------------------------------------------------------             
        IF @CD_PROD = '0'
        BEGIN
            SET @CD_PROD=''
        END
        DECLARE @TBL_PROD TABLE (CD_EMP                INT,        
                                    CD_PROD            INT,
                                    NR_NCM            VARCHAR(20),
                                    NR_CEST            VARCHAR(20),
                                    CD_CLASS_FISC    INT,
                                    DS_CLASS_FISC    VARCHAR(200),
                                    PIS_COFINS        INT,
                                    TIPO_TRIBUTACAO_PIS_COFINS INT,
                                    SIGLA_EXCECAO_PIS_COFINS    VARCHAR(10),
                                    FLAG_EXCECAO_PIS_COFINS    INT,
                                    CTR_PMC            INT,
                                    PROD_EXCESSAO_FECOP INT,
                                    ORIGEM_PRODUTO INT, 
                                    ICMS_DESONERADO INT, 
                                    MOTIVO_DESONERADO_ICMS                INT,
                                    CD_BENEF                            VARCHAR(10))
        IF NOT @CD_PROD = '' 
        BEGIN
            DECLARE @TMP_PROD TABLE(CD_PROD INT)
            INSERT INTO @TMP_PROD 
            SELECT ID 
            FROM 
                UFD_PRM_IN_STRING(@CD_PROD)
            INSERT INTO @TBL_PROD
            SELECT 
                EST_PROD.CD_EMP,
                EST_PROD.CD_PROD,
                NR_NCM,
                NR_CEST,
                CASE WHEN NOT EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC IS NULL THEN
                    EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC
                ELSE
                    ISNULL(EST_PROD.CD_CLASS_FISC,0)
                END,
                CASE WHEN NOT EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC IS NULL THEN
                    CLSFISCAREGIAO.DS_CLASS_FISC
                ELSE
                    ISNULL(EST_TRIB_CLASS_FISC.DS_CLASS_FISC,'NAO DEFINIDO')
                END,
                EST_PROD.PIS_COFINS,
                ISNULL(EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS,0),
                ISNULL(EST_PROD.SIGLA_EXCECAO_PIS_COFINS,''),
                ISNULL(EST_PROD.FLAG_EXCECAO_PIS_COFINS,0),
                ISNULL(EST_PROD.CTR_PMC,0),
                ISNULL(EST_PROD.PROD_EXCESSAO_FECOP,0),
                ISNULL(EST_PROD.ORIGEM_PRODUTO,0),                
                ISNULL(B.ICMS_DESONERADO,0),
                ISNULL(B.MOTIVO_DESONERADO_ICMS,0),
                ISNULL(B.CD_BENEF,'')
            FROM 
                EST_PROD 
                LEFT OUTER JOIN EST_TRIB_CLASS_FISC ON
                EST_PROD.CD_CLASS_FISC = EST_TRIB_CLASS_FISC.CD_CLASS_FISC
                LEFT JOIN EST_PROD_COD_BENEF B ON 
                EST_PROD.CD_EMP           = B.CD_EMP
                AND EST_PROD.CD_PROD      = B.CD_PROD  
                AND B.UF                  = @UF_FILIAL 
                LEFT OUTER JOIN EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL ON
                EST_PROD.CD_EMP = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_EMP AND
                EST_PROD.CD_PROD = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_PROD AND
                @CD_REGIAO_FISCAL = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
                LEFT OUTER JOIN EST_TRIB_CLASS_FISC CLSFISCAREGIAO ON
                EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC = CLSFISCAREGIAO.CD_CLASS_FISC
                INNER JOIN @TMP_PROD T ON 
                EST_PROD.CD_PROD = T.CD_PROD 
            WHERE
                EST_PROD.CD_EMP=@CD_EMP
                AND EST_PROD.CD_PROD IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_PROD));
        END
        ELSE
        BEGIN
            INSERT INTO @TBL_PROD
            SELECT 
                EST_PROD.CD_EMP,
                EST_PROD.CD_PROD,
                EST_PROD.NR_NCM,
                EST_PROD.NR_CEST,
                CASE WHEN NOT EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC IS NULL THEN
                    EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC
                ELSE
                    ISNULL(EST_PROD.CD_CLASS_FISC,0)
                END,
                CASE WHEN NOT EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC IS NULL THEN
                    CLSFISCAREGIAO.DS_CLASS_FISC
                ELSE
                    ISNULL(EST_TRIB_CLASS_FISC.DS_CLASS_FISC,'NAO DEFINIDO')
                END,                
                EST_PROD.PIS_COFINS,
                ISNULL(EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS,0),
                ISNULL(EST_PROD.SIGLA_EXCECAO_PIS_COFINS,''),
                ISNULL(EST_PROD.FLAG_EXCECAO_PIS_COFINS,0),
                ISNULL(EST_PROD.CTR_PMC,0),
                ISNULL(EST_PROD.PROD_EXCESSAO_FECOP,0),
                ISNULL(EST_PROD.ORIGEM_PRODUTO,0),
                ISNULL(B.ICMS_DESONERADO,0), 
                ISNULL(B.MOTIVO_DESONERADO_ICMS,0),
                ISNULL(B.CD_BENEF, '')
            FROM 
                EST_TRIB_CONF_GRP GRP
                INNER JOIN EST_TRIB_CONF_GRP_CPL GRP_CPL ON 
                GRP.CD_EMP              = GRP_CPL.CD_EMP
                AND GRP.CD_CTR          = GRP_CPL.CD_CTR
                AND GRP.FLAG_TRIB_DARE  = @GERA_DARE
                AND GRP_CPL.CD_OPER_MVA = @CD_OPER_MVA
                INNER JOIN EST_PROD_EST_TRIB_CONF_GRP GRP_PROD ON 
                GRP.CD_EMP                  = GRP_PROD.CD_EMP
                AND GRP.CD_CTR              = GRP_PROD.CD_CTR 
                INNER JOIN EST_PROD ON 
                EST_PROD.CD_EMP                 = GRP_PROD.CD_EMP
                AND EST_PROD.CD_PROD            = GRP_PROD.CD_PROD  
                LEFT JOIN EST_PROD_COD_BENEF B ON 
                EST_PROD.CD_EMP           = B.CD_EMP
                AND EST_PROD.CD_PROD      = B.CD_PROD  
                AND B.UF                  = @UF_FILIAL 
                LEFT OUTER JOIN EST_TRIB_CLASS_FISC ON
                EST_PROD.CD_CLASS_FISC = EST_TRIB_CLASS_FISC.CD_CLASS_FISC
                LEFT OUTER JOIN EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL ON
                EST_PROD.CD_EMP = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_EMP AND
                EST_PROD.CD_PROD = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_PROD AND
                @CD_REGIAO_FISCAL = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
                LEFT OUTER JOIN EST_TRIB_CLASS_FISC CLSFISCAREGIAO ON
                EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC = CLSFISCAREGIAO.CD_CLASS_FISC
            WHERE 
                GRP.CD_EMP                      = @CD_EMP
                AND GRP.CD_REGIAO_FISCAL        = @CD_REGIAO_FISCAL
                AND GRP_CPL.TP_MOV              = @TP_MOV
                AND GRP_CPL.TP_TRANSA           = @TP_MOV_OP_TRANSA
                AND GRP_CPL.UF                  = @UF_DEST_ORIG 
        END
        --SE FOR DARE NAO CONTROLA MICRO EMPRESA
        IF @GERA_DARE=1
        BEGIN
            SET @FLAG_FORN_MICRO_EMPRESA=0
        END
        --FIM
        --FILIAL MICRO EMPRESA
        IF @FILIAL_OPTANTE_SIMPLES_NACIONAL = 1
        BEGIN
            IF (@TP_MOV IN(6,11) AND @TP_MOV_OP_TRANSA=0) --DEVOLUCAO DE VENDAS FORCAR MICRO EMPRESA DESTINATARIO
                    BEGIN
                        SET @FLAG_FORN_MICRO_EMPRESA=1
                    END             
            IF @TP_MOV_OP_TRANSA=1 --SE A TRANSACAO FOR DE SAIDA SEMPRE SEMPRE MICRO EMPRESA
                    BEGIN
                        SET @FLAG_FORN_MICRO_EMPRESA=1
                    END             
        END
        --NAO MICRO EMPRESA
        IF @FILIAL_OPTANTE_SIMPLES_NACIONAL = 0
        BEGIN
            IF (@TP_MOV=11 AND @TP_MOV_OP_TRANSA=0) --DEVOLUCAO DE VENDAS FORCAR MICRO EMPRESA DESTINATARIO
                    BEGIN
                        SET @FLAG_FORN_MICRO_EMPRESA=0
                    END             
            IF @TP_MOV_OP_TRANSA=1 --SE A TRANSACAO FOR DE SAIDA SEMPRE SEMPRE MICRO EMPRESA
                    BEGIN
                        SET @FLAG_FORN_MICRO_EMPRESA=0
                    END        
            IF @GERA_DARE = 1
                    BEGIN
                        SET @FLAG_FORN_MICRO_EMPRESA=0
                    END
        END
----------------------------------------------------------------------------------------------------------------
--VERIFICANDO SE EXISTE TRIBUTACAO PARA O FORNECEDOR
----------------------------------------------------------------------------------------------------------------             
        IF @TP_MOV_OP_TRANSA = 0 AND @DEST_ORIG = 1 
        BEGIN
            INSERT INTO @TBL_TRIB_PROD     
            (CD_ID,    
            CD_EMP,
            CD_PROD,    
            CD_CTR,    
            CD_TRIB_CST,
            UF,
            UF_FILIAL,
            TP_MOV,
            TP_TRANSA,
            TP_LISTA,
            DS_TP_LISTA,
            NR_NCM,
            NR_CEST,
            CD_CLASS_FISC,
            DS_CLASS_FISC,
            PERC_RED,
            PERC_ICMS,
            TP_RED_BASE_IMP,
            PERC_RED_SUBS_TRIB,
            PERC_RED_ESTORNO,
            PERC_REPASSE,
            PERC_IBPT,
            TP_GERACAO_DARE,
            FLAG_TRIB_DARE,
            VLR_PAUTA_IVA,
            TP_SUBS,
            DS_TP_SUBS,
            PERC_ICMS_EST,
            PERC_ICMS_ORIGEM,
            HIST,
            CD_TRIB,
            CD_TRIB_FC,
            ICMS,
            SUBS_TRIB,
            ICMS_RD,
            SUBS_TRIB_ANT,
            ISENTO,
            TIPO_REGIME_EMPRESA,
            FLAG_VLR_SUBST_TOTAL_PROD, 
            FLAG_GERAR_ICMS_SUBS_DARE, 
            FLAG_OUTROS,
            ORIGEM_PRODUTO,
            DS_ORIGEM_PRODUTO,
            CD_TBL_MVA,
            CD_REGIAO_FISCAL,
            NM_REGIAO_FISCAL,
            VLR_PAUTA_IVA_ORIGINAL,
            MVA_AJUSTADO,
            TIPO_TRIBUTACAO_PIS_COFINS,
            SIGLA_EXCECAO_PIS_COFINS,
            FLAG_EXCECAO_PIS_COFINS,
            PIS_COFINS,
            FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP,
            FLAG_TRIB_PIS_COFINS_PROD,
            CTR_PMC,
            FLAG_GERAR_ICMS_RETIDO,
            PERC_RED_IMPORTADO,
            PERC_RED_SUBS_TRIB_IMPORTADO,
            TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            TIPO_REGIME_DESTINATARIO_ORIGEM,
            DS_TIPO_REGIME_DESTINATARIO_ORIGEM,
            OBS_GRUPO_TRIB_NF,
            EXCECAO_MVA_PRODUTO,
            MODALI_BASE_ICMS_SUBST,
            DS_MODALI_BASE_ICMS_SUBST,
            PRECO_BASE_SUBS,
            PERC_REDU_PMC_FORN,
            TIPO_REGIME_FILIAL,
            DS_TIPO_REGIME_FILIAL,
            TRIBUTACAO_FORNECEDOR,
            VLR_PMC,
            VLR_ICMS_SUBS_GARANTIR,
            PERC_ICMS_DESTINO_DIFAL,
            PERC_ICMS_ORIGEM_DIFAL,
            GERAR_DIFAL,
            GERAR_DARE,
            CONTRIBUINTE,
            FLAG_GERAR_MOV_DARE,
            GERAR_SUBS_TRIB,
            TP_SUBS_TRIB,
            PERC_ALIQ_FECOP,
            FLAG_FRETE_BASE_ICMS,
            FCOP,            
            ICMS_DESONERADO,
            MOTIVO_DESONERADO_ICMS,
            VLR_ICMS_DESONERADO,
            PERC_ICMS_DESONERADO,
            CD_BENEF,
			PERC_DIFERIMENTO,
			VLR_DIFERIMENTO
            )
            SELECT 
                ROW_NUMBER() OVER (PARTITION BY GRP_PROD.CD_EMP, 
                                    GRP_PROD.CD_PROD ORDER BY GRP_PROD.CD_EMP, 
                                    GRP_PROD.CD_PROD, GRP_PROD.CD_CTR) AS CD_ID,
                GRP_PROD.CD_EMP,
                GRP_PROD.CD_PROD,
                GRP_PROD.CD_CTR,    
                GRP_CPL.CD_TRIB_CST,
                GRP_CPL.UF,
                @UF_FILIAL,
                GRP_CPL.TP_MOV,
                GRP_CPL.TP_TRANSA,                                                      
                GRP.TP_LISTA,
                CASE WHEN GRP.TP_LISTA=0 THEN
                    'POSITIVA'
                WHEN GRP.TP_LISTA=1 THEN
                    'NEGATIVA'
                WHEN GRP.TP_LISTA=2 THEN
                    'NEUTRA'
                WHEN GRP.TP_LISTA=3 THEN
                    'NAO USA LISTA'
                END AS DS_TP_LISTA,
                EST_PROD.NR_NCM,
                EST_PROD.NR_CEST,
                EST_PROD.CD_CLASS_FISC,
                DS_CLASS_FISC,
                GRP_CPL.PERC_RED,
                ISNULL(GRP_CPL.PERC_ICMS_ORIGEM,0) AS PERC_ICMS,
                GRP_CPL.TP_RED_BASE_IMP,
                GRP_CPL.PERC_RED_SUBS_TRIB,
                GRP_CPL.PERC_RED_ESTORNO,
                GRP_CPL.PERC_REPASSE,
                GRP_CPL.PERC_IBPT,
                GRP_CPL.TP_GERACAO_DARE,
                GRP.FLAG_TRIB_DARE,
                0                           AS VLR_PAUTA_IVA,
                0                           AS TP_SUBS,
                ''                            AS DS_TP_SUBS,
                GRP_CPL.PERC_ICMS            AS PERC_ICMS_EST,
                GRP_CPL.PERC_ICMS_ORIGEM    AS PERC_ICMS_ORIGEM,
                ''                          AS HIST,
                0 AS                        CD_TRIB,
                '' AS                       CD_TRIB_FC,
                0 AS                        ICMS,
                0 AS                        SUBS_TRIB,
                0 AS                        ICMS_RD,
                0 AS                        SUBS_TRIB_ANT,
                0 AS                        ISENTO,
                0 AS                        TIPO_REGIME_EMPRESA,
                0 AS                        FLAG_VLR_SUBST_TOTAL_PROD,
                0 AS                        FLAG_GERAR_ICMS_SUBS_DARE,
                0 AS                        FLAG_OUTROS,
                ISNULL(EST_PROD.ORIGEM_PRODUTO,0) AS                        ORIGEM_PRODUTO,
                '' AS                        DS_ORIGEM_PRODUTO,
                0 AS                        CD_TBL_MVA,
                @CD_REGIAO_FISCAL,
                @NM_REGIAO_FISCAL,
                0 AS VLR_PAUTA_IVA_ORIGINAL,
                GRP_CPL.MVA_AJUSTADO,
                EST_PROD.PIS_COFINS,
                EST_PROD.SIGLA_EXCECAO_PIS_COFINS,
                EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS,
                EST_PROD.FLAG_EXCECAO_PIS_COFINS,
                0 AS FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP,
                0 AS FLAG_TRIB_PIS_COFINS_PROD,
                EST_PROD.CTR_PMC,
                @FLAG_GERAR_ICMS_RETIDO,
                ISNULL(GRP_CPL.PERC_RED_IMPORTADO,0),
                ISNULL(GRP_CPL.PERC_RED_SUBS_TRIB_IMPORTADO,0),
                ISNULL(GRP_CPL.TIPO_REGIME_EMPRESA,0) AS TIPO_REGIME_EMPRESA_GRUPO_TRIB,
                CASE WHEN ISNULL(GRP_CPL.TIPO_REGIME_EMPRESA,0)=0 THEN
                     'PRESUMIDO\LUCRO REAL'
                ELSE
                     'SIMPLES NACIONAL'
                END AS DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
                @FLAG_FORN_MICRO_EMPRESA,
                CASE WHEN ISNULL(@FLAG_FORN_MICRO_EMPRESA,0)=0 THEN
                     'PRESUMIDO\LUCRO REAL'
                ELSE
                     'SIMPLES NACIONAL (MICRO EMPRESA)'
                END AS DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
                ISNULL(OBS_GRUPO_TRIB_NF,''),
                0 AS EXCECAO_MVA_PRODUTO,
                CASE WHEN @PRECO_BASE_SUBS IN (1,3) THEN 0 ELSE 4 END AS MODALI_BASE_ICMS_SUBST,
                CASE WHEN @PRECO_BASE_SUBS =0 THEN 
                    'VALOR DA NOTA FISCAL' 
                WHEN @PRECO_BASE_SUBS =1 THEN 
                    'PRECO MAXIMO AO CONSUMIDOR'
                WHEN @PRECO_BASE_SUBS =2 THEN 
                    'REPASSE DE VALOR SEM CREDITO E DEBITO DE ICMS'
                WHEN @PRECO_BASE_SUBS =3 THEN 
                    'PRECO MAXIMO CONSUMIDOR RESPEITANDO REDUCAO DO CADASTRO PRODUTO'
                ELSE 
                    'NAO DEFINIDO'
                END AS DS_MODALI_BASE_ICMS_SUBST,
                @PRECO_BASE_SUBS,
                @PERC_REDU_BASE_PMC,
                @FILIAL_OPTANTE_SIMPLES_NACIONAL,
                CASE WHEN @FILIAL_OPTANTE_SIMPLES_NACIONAL=0 THEN
                    'PRESUMIDO\LUCRO REAL'
                ELSE
                    'SIMPLES NACIONAL'
                END,
                'SIM' AS TRIBUTACAO_FORNECEDOR,
                0 AS VLR_PMC,
                0 AS VLR_ICMS_SUBS_GARANTIR,
                --ISNULL(GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO,0) AS PERC_ICMS_DESTINO_DIFAL,
                CASE WHEN ISNULL(GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO,0) > 0 THEN 
                    GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO
                WHEN GRP_CPL.PERC_ICMS> 0  THEN
                    GRP_CPL.PERC_ICMS
                ELSE                 
                    0    
                END AS PERC_ICMS_DESTINO_DIFAL,
                ISNULL(GRP_CPL.PERC_ICMS_ORIGEM,0) AS PERC_ICMS_ORIGEM_DIFAL,
                0 AS GERAR_DIFAL,
                0 AS GERAR_DAR,
                @CONTRIBUINTE,
                @FLAG_GERAR_MOV_DARE,
                @SUBS_TRIB,
                @TP_SUBS_TRIB,
                0 AS PERC_ALIQ_FECOP,
                @FLAG_FRETE_BASE_ICMS,
                ISNULL(GRP_CPL.FCOP,0),
                EST_PROD.ICMS_DESONERADO,                 
                EST_PROD.MOTIVO_DESONERADO_ICMS,
                0 VLR_ICMS_DESONERADO,    
                0 PERC_ICMS_DESONERADO,
                EST_PROD.CD_BENEF ,
				GRP_CPL.PERC_DIFERIMENTO,
				0 AS VLR_DIFERIMENTO
            FROM 
                EST_TRIB_CONF_GRP GRP     -- 
                INNER JOIN EST_TRIB_CONF_GRP_CPL GRP_CPL ON 
                GRP.CD_EMP                = GRP_CPL.CD_EMP
                AND GRP.CD_CTR            = GRP_CPL.CD_CTR
                AND GRP.FLAG_TRIB_DARE  = @GERA_DARE
                AND GRP_CPL.CD_OPER_MVA = @CD_OPER_MVA
                INNER JOIN EST_PROD_EST_TRIB_CONF_GRP_PG_FORN GRP_PROD ON 
                GRP.CD_EMP                              = GRP_PROD.CD_EMP
                AND GRP.CD_CTR                          = GRP_PROD.CD_CTR
                INNER JOIN @TBL_PROD EST_PROD ON 
                EST_PROD.CD_EMP                 = GRP_PROD.CD_EMP AND 
                EST_PROD.CD_PROD            = GRP_PROD.CD_PROD AND
                EST_PROD.CD_CLASS_FISC            = GRP.CD_CLASS_FISC                             
            WHERE 
                GRP.CD_EMP                      = @CD_EMP
                AND GRP.CD_REGIAO_FISCAL        = @CD_REGIAO_FISCAL
                AND GRP_CPL.TP_MOV              = @TP_MOV
                AND GRP_CPL.TP_TRANSA           = @TP_MOV_OP_TRANSA
                AND GRP_CPL.UF                  = @UF_DEST_ORIG
                AND GRP_PROD.CD_FORN            = @CD_DEST_ORIG 
                AND GRP_CPL.TIPO_REGIME_EMPRESA = @FLAG_FORN_MICRO_EMPRESA
        END
----------------------------------------------------------------------------------------------------------------
--VERIFICANDO A TRIBUTACAO ESTADUAL/INTERESTADUAL
----------------------------------------------------------------------------------------------------------------             
        INSERT INTO @TBL_TRIB_PROD     
            (CD_ID,    
            CD_EMP,
            CD_PROD,    
            CD_CTR,    
            CD_TRIB_CST,
            UF,
            UF_FILIAL,
            TP_MOV,
            TP_TRANSA,
            TP_LISTA,
            DS_TP_LISTA,
            NR_NCM,
            NR_CEST,
            CD_CLASS_FISC,
            DS_CLASS_FISC,
            PERC_RED,
            PERC_ICMS,
            TP_RED_BASE_IMP,
            PERC_RED_SUBS_TRIB,
            PERC_RED_ESTORNO,
            PERC_REPASSE,
            PERC_IBPT,
            TP_GERACAO_DARE,
            FLAG_TRIB_DARE,
            VLR_PAUTA_IVA,
            TP_SUBS,
            DS_TP_SUBS,
            PERC_ICMS_EST,
            PERC_ICMS_ORIGEM,
            HIST,
            CD_TRIB,
            CD_TRIB_FC,
            ICMS,
            SUBS_TRIB,
            ICMS_RD,
            SUBS_TRIB_ANT,
            ISENTO,
            TIPO_REGIME_EMPRESA,
            FLAG_VLR_SUBST_TOTAL_PROD, 
            FLAG_GERAR_ICMS_SUBS_DARE, 
            FLAG_OUTROS,
            ORIGEM_PRODUTO,
            DS_ORIGEM_PRODUTO,
            CD_TBL_MVA,
            CD_REGIAO_FISCAL,
            NM_REGIAO_FISCAL,
            VLR_PAUTA_IVA_ORIGINAL,
            MVA_AJUSTADO,
            TIPO_TRIBUTACAO_PIS_COFINS,
            SIGLA_EXCECAO_PIS_COFINS,
            FLAG_EXCECAO_PIS_COFINS,
            PIS_COFINS,
            FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP,
            FLAG_TRIB_PIS_COFINS_PROD,
            CTR_PMC,
            FLAG_GERAR_ICMS_RETIDO,
            PERC_RED_IMPORTADO,
            PERC_RED_SUBS_TRIB_IMPORTADO,
            TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            TIPO_REGIME_DESTINATARIO_ORIGEM,
            DS_TIPO_REGIME_DESTINATARIO_ORIGEM,
            OBS_GRUPO_TRIB_NF,
            EXCECAO_MVA_PRODUTO,
            MODALI_BASE_ICMS_SUBST,
            DS_MODALI_BASE_ICMS_SUBST,
            PRECO_BASE_SUBS,
            PERC_REDU_PMC_FORN,
            TIPO_REGIME_FILIAL,
            DS_TIPO_REGIME_FILIAL,
            TRIBUTACAO_FORNECEDOR,
            VLR_PMC,
            VLR_ICMS_SUBS_GARANTIR,
            PERC_ICMS_DESTINO_DIFAL,
            PERC_ICMS_ORIGEM_DIFAL,
            GERAR_DIFAL,
            GERAR_DARE,
            CONTRIBUINTE,
            FLAG_GERAR_MOV_DARE,
            GERAR_SUBS_TRIB,
            TP_SUBS_TRIB,
            PERC_ALIQ_FECOP,
            FLAG_FRETE_BASE_ICMS,
            FCOP,
            ICMS_DESONERADO,
            MOTIVO_DESONERADO_ICMS,
            VLR_ICMS_DESONERADO,
            PERC_ICMS_DESONERADO,
            CD_BENEF,
			PERC_DIFERIMENTO,
			VLR_DIFERIMENTO)
        SELECT 
            ROW_NUMBER() OVER (PARTITION BY GRP_PROD.CD_EMP, GRP_PROD.CD_PROD ORDER BY GRP_PROD.CD_EMP, GRP_PROD.CD_PROD, GRP_PROD.CD_CTR) AS CD_ID,
            GRP_PROD.CD_EMP,
            GRP_PROD.CD_PROD,
            GRP_PROD.CD_CTR,
            GRP_CPL.CD_TRIB_CST,
            GRP_CPL.UF,
            @UF_FILIAL,
            GRP_CPL.TP_MOV,
            GRP_CPL.TP_TRANSA,
            GRP.TP_LISTA,
            CASE WHEN GRP.TP_LISTA=0 THEN
                'POSITIVA'
            WHEN GRP.TP_LISTA=1 THEN
                'NEGATIVA'
            WHEN GRP.TP_LISTA=2 THEN
                'NEUTRA'
            WHEN GRP.TP_LISTA=3 THEN
                'NAO USA LISTA'
            END AS DS_TP_LISTA,
            EST_PROD.NR_NCM,
          EST_PROD.NR_CEST,
            EST_PROD.CD_CLASS_FISC,
            DS_CLASS_FISC,
            GRP_CPL.PERC_RED,
            ISNULL(GRP_CPL.PERC_ICMS_ORIGEM,0) AS PERC_ICMS,
            GRP_CPL.TP_RED_BASE_IMP,
            GRP_CPL.PERC_RED_SUBS_TRIB,
            GRP_CPL.PERC_RED_ESTORNO,
            GRP_CPL.PERC_REPASSE,
            GRP_CPL.PERC_IBPT,
            GRP_CPL.TP_GERACAO_DARE,
            GRP.FLAG_TRIB_DARE,     
            0                                                       AS VLR_PAUTA_IVA,
            0                                                       AS TP_SUBS,
            ''    AS DS_TP_SUBS,
            GRP_CPL.PERC_ICMS AS PERC_ICMS_EST,
            GRP_CPL.PERC_ICMS_ORIGEM AS PERC_ICMS_ORIGEM,
            ''  AS HIST,
            0 AS                                            CD_TRIB,
            '' AS                                           CD_TRIB_FC,
            0 AS                                            ICMS,
            0 AS                                            SUBS_TRIB,
            0 AS                                            ICMS_RD,
            0 AS                                            SUBS_TRIB_ANT,
            0 AS                                            ISENTO,
            0 AS                                            TIPO_REGIME_EMPRESA,
            0 AS                                            FLAG_VLR_SUBST_TOTAL_PROD,
            0 AS                                            FLAG_GERAR_ICMS_SUBS_DARE,
            0 AS                                            FLAG_OUTROS,
            ISNULL(EST_PROD.ORIGEM_PRODUTO,0) AS                                            ORIGEM_PRODUTO,
            '' AS DS_ORIGEM_PRODUTO,
            0 AS                                            CD_TBL_MVA,
            @CD_REGIAO_FISCAL,
            @NM_REGIAO_FISCAL,
            0 AS VLR_PAUTA_IVA_ORIGINAL,
            GRP_CPL.MVA_AJUSTADO,
            EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS,
            EST_PROD.SIGLA_EXCECAO_PIS_COFINS,
            EST_PROD.FLAG_EXCECAO_PIS_COFINS,
            EST_PROD.PIS_COFINS,
            0 AS FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP,
            0 AS FLAG_TRIB_PIS_COFINS_PROD,
            EST_PROD.CTR_PMC,
            @FLAG_GERAR_ICMS_RETIDO,
            ISNULL(GRP_CPL.PERC_RED_IMPORTADO,0),
            ISNULL(GRP_CPL.PERC_RED_SUBS_TRIB_IMPORTADO,0),
            ISNULL(GRP_CPL.TIPO_REGIME_EMPRESA,0) AS TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            CASE WHEN ISNULL(GRP_CPL.TIPO_REGIME_EMPRESA,0)=0 THEN
                    'PRESUMIDO\LUCRO REAL'
            ELSE
                    'SIMPLES NACIONAL'
            END AS DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            @FLAG_FORN_MICRO_EMPRESA,
            CASE WHEN ISNULL(@FLAG_FORN_MICRO_EMPRESA,0)=0 THEN
                    'PRESUMIDO\LUCRO REAL'
            ELSE
                    'SIMPLES NACIONAL (MICRO EMPRESA)'
            END AS DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB,
            ISNULL(OBS_GRUPO_TRIB_NF,''),
            0 AS EXCECAO_MVA_PRODUTO,
            CASE WHEN @PRECO_BASE_SUBS IN (1,3) THEN 0 ELSE 4 END AS MODALI_BASE_ICMS_SUBST,
            CASE WHEN @PRECO_BASE_SUBS =0 THEN 
                'VALOR DA NOTA FISCAL' 
            WHEN @PRECO_BASE_SUBS =1 THEN 
                'PRECO MAXIMO AO CONSUMIDOR'
            WHEN @PRECO_BASE_SUBS =2 THEN 
                'REPASSE DE VALOR SEM CREDITO E DEBITO DE ICMS'
            WHEN @PRECO_BASE_SUBS =3 THEN 
                'PRECO MAXIMO CONSUMIDOR RESPEITANDO REDUCAO DO CADASTRO PRODUTO'
            ELSE 
                'NAO DEFINIDO'
            END AS DS_MODALI_BASE_ICMS_SUBST,
            @PRECO_BASE_SUBS,
            @PERC_REDU_BASE_PMC,
            @FILIAL_OPTANTE_SIMPLES_NACIONAL,
            CASE WHEN @FILIAL_OPTANTE_SIMPLES_NACIONAL=0 THEN
                'PRESUMIDO\LUCRO REAL'
            ELSE
                'SIMPLES NACIONAL'
            END,
            'NAO' AS TRIBUTACAO_FORNECEDOR,
            0 AS VLR_PMC,
            0 AS VLR_ICMS_SUBS_GARANTIR,
               -- GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO AS PERC_ICMS_DESTINO_DIFAL,
            CASE WHEN ISNULL(GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO,0) > 0 THEN 
                    GRP_CPL.PERC_ICMS_DIFAL_EXCESSAO
                    WHEN GRP_CPL.PERC_ICMS> 0  THEN
                       GRP_CPL.PERC_ICMS
                ELSE
                    0    END AS PERC_ICMS_DESTINO_DIFAL,
            ISNULL(GRP_CPL.PERC_ICMS_ORIGEM,0) AS PERC_ICMS_ORIGEM_DIFAL,
            0 AS GERAR_DIFAL,
            0 AS GERAR_DAR,
            @CONTRIBUINTE,
            @FLAG_GERAR_MOV_DARE,
            @SUBS_TRIB,
            @TP_SUBS_TRIB,
            0 AS PERC_ALIQ_FECOP,
            @FLAG_FRETE_BASE_ICMS,
            ISNULL(GRP_CPL.FCOP,0),
            EST_PROD.ICMS_DESONERADO,                 
            EST_PROD.MOTIVO_DESONERADO_ICMS,
            0 VLR_ICMS_DESONERADO,
            0 PERC_ICMS_DESONERADO,
            EST_PROD.CD_BENEF,
			GRP_CPL.PERC_DIFERIMENTO,
			0 AS VLR_DIFERIMENTO
        FROM 
            EST_TRIB_CONF_GRP GRP
            INNER JOIN EST_TRIB_CONF_GRP_CPL GRP_CPL ON 
            GRP.CD_EMP              = GRP_CPL.CD_EMP
            AND GRP.CD_CTR          = GRP_CPL.CD_CTR
            AND GRP.FLAG_TRIB_DARE  = @GERA_DARE
            AND GRP_CPL.CD_OPER_MVA = @CD_OPER_MVA
            INNER JOIN EST_PROD_EST_TRIB_CONF_GRP GRP_PROD ON 
            GRP.CD_EMP                  = GRP_PROD.CD_EMP
            AND GRP.CD_CTR              = GRP_PROD.CD_CTR
            INNER JOIN @TBL_PROD EST_PROD ON 
            EST_PROD.CD_EMP             = GRP_PROD.CD_EMP AND
            EST_PROD.CD_PROD            = GRP_PROD.CD_PROD AND                             
            EST_PROD.CD_CLASS_FISC      = GRP.CD_CLASS_FISC            
        WHERE 
            GRP.CD_EMP                      = @CD_EMP
            AND GRP.CD_REGIAO_FISCAL        = @CD_REGIAO_FISCAL
            AND GRP_CPL.TP_MOV              = @TP_MOV
            AND GRP_CPL.TP_TRANSA           = @TP_MOV_OP_TRANSA
            AND GRP_CPL.UF                  = @UF_DEST_ORIG
            AND GRP_CPL.TIPO_REGIME_EMPRESA = @FLAG_FORN_MICRO_EMPRESA
               AND NOT EXISTS (SELECT TBL_TRIB_PROD.CD_EMP
                            FROM @TBL_TRIB_PROD TBL_TRIB_PROD
                            WHERE   
                                TBL_TRIB_PROD.CD_EMP            = GRP_PROD.CD_EMP
                                AND TBL_TRIB_PROD.CD_PROD       = GRP_PROD.CD_PROD)          
----------------------------------------------------------------------------------------------------------------
--REMOVENDO OS TRIBUTACOES DUPLICADAS PARA O PRODUTO
----------------------------------------------------------------------------------------------------------------             
    DELETE FROM @TBL_TRIB_PROD
    WHERE CD_ID > 1      
----------------------------------------------------------------------------------------------------------------
--ATUALIZANDO DADOS DA CST (TRIBUTACAO) NO PRODUTO PARA FILIAIS OPTANTE PELO SIMPLES OU REGIME NORMAL
----------------------------------------------------------------------------------------------------------------
        IF @FILIAL_OPTANTE_SIMPLES_NACIONAL = 1
        BEGIN
            UPDATE 
                TBL_TRIB_PROD 
            SET        
                HIST                        = EST_TRIB.HIST,
                CD_TRIB                     = EST_TRIB.CD_TRIB,
                CD_TRIB_FC                  = EST_TRIB.CD_TRIB_FC,
                ICMS                        = EST_TRIB.ICMS,
                SUBS_TRIB                   = EST_TRIB.SUBS_TRIB,
                ICMS_RD                     = EST_TRIB.ICMS_RD,
                SUBS_TRIB_ANT               = EST_TRIB.SUBS_TRIB_ANT,
                ISENTO                      = EST_TRIB.ISENTO,
                TIPO_REGIME_EMPRESA         = EST_TRIB.TIPO_REGIME_EMPRESA,
                FLAG_VLR_SUBST_TOTAL_PROD   = EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD,
                FLAG_GERAR_ICMS_SUBS_DARE   = EST_TRIB.FLAG_GERAR_ICMS_SUBS_DARE,
                FLAG_OUTROS                 = EST_TRIB.FLAG_OUTROS,
                ORIGEM_PRODUTO              = ISNULL(EST_PROD.ORIGEM_PRODUTO,0),
                DS_ORIGEM_PRODUTO=CASE WHEN ISNULL(EST_PROD.ORIGEM_PRODUTO,0)=0 THEN 
                        'NACIONAL' 
                WHEN EST_PROD.ORIGEM_PRODUTO=1 THEN 
                        'ESTRANGEIRA - IMPORTAO DIRETA'
                WHEN EST_PROD.ORIGEM_PRODUTO=2 THEN 
                        'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO'
                WHEN EST_PROD.ORIGEM_PRODUTO=3 THEN 
                        'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR A  40% ATE 70%'
                WHEN EST_PROD.ORIGEM_PRODUTO=4 THEN 
                        'NACIONAL, CUJA PRODUO TENHA SIDO FEITA EM CONFORMIDADE COM OS PROCESSOS PRODUTIVOS BSICOS DE QUE TRATAM O DECRETO-LEI N 288/67, E AS LEIS NS 8.248/91, 8.387/91, 10.176/01 E 11.484/07'
                WHEN EST_PROD.ORIGEM_PRODUTO=5 THEN 
                        'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTA??O INFERIOR OU IGUAL A 40% (QUARENTA POR CENTO)'
                WHEN EST_PROD.ORIGEM_PRODUTO=6 THEN 
                        'ESTRANGEIRA - IMPORTAO DIRETA, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                WHEN EST_PROD.ORIGEM_PRODUTO=7 THEN 
                        'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                WHEN EST_PROD.ORIGEM_PRODUTO=8 THEN 
                        'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR 70%'
                ELSE 
                        'NAO DEFINIDO'
                END,
                MODALI_BASE_ICMS_SUBST      = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE MODALI_BASE_ICMS_SUBST END,
                DS_MODALI_BASE_ICMS_SUBST   = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN '' ELSE DS_MODALI_BASE_ICMS_SUBST END,
                PRECO_BASE_SUBS             = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PRECO_BASE_SUBS END, 
                PERC_REDU_PMC_FORN          = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PERC_REDU_PMC_FORN END ,
                ICMS_DESONERADO 		    = ISNULL(EST_TRIB.ICMS_DESONERADO, 0),
				MOTIVO_DESONERADO_ICMS      = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.MOTIVO_DESONERADO_ICMS ELSE 0 END ,
                CD_BENEF                    = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.CD_BENEF ELSE '' END
            FROM 
                @TBL_TRIB_PROD TBL_TRIB_PROD
                INNER JOIN EST_PROD ON 
                TBL_TRIB_PROD.CD_EMP            = EST_PROD.CD_EMP               
                AND TBL_TRIB_PROD.CD_PROD       = EST_PROD.CD_PROD
                INNER JOIN EST_TRIB ON 
                TBL_TRIB_PROD.CD_TRIB_CST       = EST_TRIB.CD_TRIB_CST
                AND  EST_PROD.ORIGEM_PRODUTO    = CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN EST_TRIB.ORIGEM_PRODUTO ELSE EST_PROD.ORIGEM_PRODUTO  END
            WHERE 
                EST_TRIB.TIPO_REGIME_EMPRESA =CASE WHEN @TP_MOV_OP_TRANSA=1  THEN --SE FOR SAIDA RESPEITA A FILIAL
                                                                    1
                                                                 ELSE --SE FOR ENTRADA RESPEITA O EMITENTE
                                                                    CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN 
                                                                        0 
                                                                    ELSE 
                                                                        1 
                                                                    END  
                                                                END 
                AND TBL_TRIB_PROD.TIPO_REGIME_EMPRESA_GRUPO_TRIB=CASE WHEN @TP_MOV_OP_TRANSA=1  THEN --SE FOR SAIDA RESPEITA A FILIAL
                                                                    1
                                                                 ELSE --SE FOR ENTRADA RESPEITA O EMITENTE
                                                                    CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN 
                                                                        0 
                                                                    ELSE 
                                                                        1 
                                                                    END  
                                                                END
        END
        ELSE
        BEGIN
            --DESTINATARIO/EMITENTE NAO SIMPLES
            IF @FLAG_FORN_MICRO_EMPRESA=0 
            BEGIN
                UPDATE 
                    TBL_TRIB_PROD 
                SET        
                    HIST                    = EST_TRIB.HIST,
                    CD_TRIB                 = EST_TRIB.CD_TRIB,
                    CD_TRIB_FC              = EST_TRIB.CD_TRIB_FC,
                    ICMS                    = EST_TRIB.ICMS,
                    SUBS_TRIB               = EST_TRIB.SUBS_TRIB,
                    ICMS_RD                 = EST_TRIB.ICMS_RD,
                    SUBS_TRIB_ANT           = EST_TRIB.SUBS_TRIB_ANT,
                    ISENTO                  = EST_TRIB.ISENTO,
                    TIPO_REGIME_EMPRESA     = EST_TRIB.TIPO_REGIME_EMPRESA,
                    FLAG_VLR_SUBST_TOTAL_PROD = EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD,
                    FLAG_GERAR_ICMS_SUBS_DARE = EST_TRIB.FLAG_GERAR_ICMS_SUBS_DARE,
                    FLAG_OUTROS               = EST_TRIB.FLAG_OUTROS,
                    ORIGEM_PRODUTO            = ISNULL(EST_PROD.ORIGEM_PRODUTO,0),
                    DS_ORIGEM_PRODUTO=CASE WHEN ISNULL(EST_PROD.ORIGEM_PRODUTO,0)=0 THEN 
                            'NACIONAL' 
                    WHEN EST_PROD.ORIGEM_PRODUTO=1 THEN 
                            'ESTRANGEIRA - IMPORTA??O DIRETA'
                    WHEN EST_PROD.ORIGEM_PRODUTO=2 THEN 
                            'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO'
                    WHEN EST_PROD.ORIGEM_PRODUTO=3 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR A  40% ATE 70%'
                    WHEN EST_PROD.ORIGEM_PRODUTO=4 THEN 
                            'NACIONAL, CUJA PRODU??O TENHA SIDO FEITA EM CONFORMIDADE COM OS PROCESSOS PRODUTIVOS BSICOS DE QUE TRATAM O DECRETO-LEI N 288/67, E AS LEIS NS 8.248/91, 8.387/91, 10.176/01 E 11.484/07'
                    WHEN EST_PROD.ORIGEM_PRODUTO=5 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTE?DO DE IMPORTAO INFERIOR OU IGUAL A 40% (QUARENTA POR CENTO)'
                    WHEN EST_PROD.ORIGEM_PRODUTO=6 THEN 
                            'ESTRANGEIRA - IMPORTAO DIRETA, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                    WHEN EST_PROD.ORIGEM_PRODUTO=7 THEN 
                            'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                    WHEN EST_PROD.ORIGEM_PRODUTO=8 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR 70%'
                    ELSE 
                            'NAO DEFINIDO'
                    END,
                    MODALI_BASE_ICMS_SUBST      = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE MODALI_BASE_ICMS_SUBST END,
                    DS_MODALI_BASE_ICMS_SUBST   = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN '' ELSE DS_MODALI_BASE_ICMS_SUBST END,
                    PRECO_BASE_SUBS             = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PRECO_BASE_SUBS END, 
                    PERC_REDU_PMC_FORN          = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PERC_REDU_PMC_FORN END  ,
                    ICMS_DESONERADO 			= ISNULL(EST_TRIB.ICMS_DESONERADO, 0),
					MOTIVO_DESONERADO_ICMS      = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.MOTIVO_DESONERADO_ICMS ELSE 0 END ,
                    CD_BENEF                    = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.CD_BENEF ELSE '' END        
                FROM 
                    @TBL_TRIB_PROD TBL_TRIB_PROD
                    INNER JOIN EST_PROD ON 
                    TBL_TRIB_PROD.CD_EMP      = EST_PROD.CD_EMP               
                    AND TBL_TRIB_PROD.CD_PROD = EST_PROD.CD_PROD
                    INNER JOIN EST_TRIB ON 
                    TBL_TRIB_PROD.CD_TRIB_CST                = EST_TRIB.CD_TRIB_CST                          
                    AND ISNULL(EST_PROD.ORIGEM_PRODUTO,0)   = CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN EST_TRIB.ORIGEM_PRODUTO ELSE EST_PROD.ORIGEM_PRODUTO  END                              
                WHERE 
                    EST_TRIB.TIPO_REGIME_EMPRESA = CASE WHEN @TP_MOV_OP_TRANSA=1  THEN --SE FOR SAIDA RESPEITA A FILIAL
                                                                    0
                                                                 ELSE --SE FOR ENTRADA RESPEITA O EMITENTE
                                                                    CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN 
                                                                        0 
                                                                    ELSE 
                                                                        1 
                                                                    END  
                                                                END
                    AND TBL_TRIB_PROD.TIPO_REGIME_EMPRESA_GRUPO_TRIB=CASE WHEN @TP_MOV_OP_TRANSA=1  THEN --SE FOR SAIDA RESPEITA A FILIAL
                                                                    0
                                                                 ELSE --SE FOR ENTRADA RESPEITA O EMITENTE
                                                                    CASE WHEN @FLAG_FORN_MICRO_EMPRESA=0 THEN 
                                                                        0 
                                                                    ELSE 
                                                                        1 
                                                                    END  
                                                                END
            END
            --DESTINATARIO/EMITENTE SIMPLES
            IF @FLAG_FORN_MICRO_EMPRESA=1 
            BEGIN
                UPDATE 
                    TBL_TRIB_PROD 
                SET        
                    HIST                    = EST_TRIB.HIST,
                    CD_TRIB                 = EST_TRIB.CD_TRIB,
                    CD_TRIB_FC              = EST_TRIB.CD_TRIB_FC,
                    ICMS                    = EST_TRIB.ICMS,
                    SUBS_TRIB               = EST_TRIB.SUBS_TRIB,
                    ICMS_RD                 = EST_TRIB.ICMS_RD,
                    SUBS_TRIB_ANT           = EST_TRIB.SUBS_TRIB_ANT,
                    ISENTO                  = EST_TRIB.ISENTO,
                    TIPO_REGIME_EMPRESA     = EST_TRIB.TIPO_REGIME_EMPRESA,
                    FLAG_VLR_SUBST_TOTAL_PROD = EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD,
                    FLAG_GERAR_ICMS_SUBS_DARE = EST_TRIB.FLAG_GERAR_ICMS_SUBS_DARE,
                    FLAG_OUTROS               = EST_TRIB.FLAG_OUTROS,
                    ORIGEM_PRODUTO            = ISNULL(EST_PROD.ORIGEM_PRODUTO,0),
                    DS_ORIGEM_PRODUTO=CASE WHEN ISNULL(EST_PROD.ORIGEM_PRODUTO,0)=0 THEN 
                            'NACIONAL' 
                    WHEN EST_PROD.ORIGEM_PRODUTO=1 THEN 
                            'ESTRANGEIRA - IMPORTA??O DIRETA'
                    WHEN EST_PROD.ORIGEM_PRODUTO=2 THEN 
                            'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO'
                    WHEN EST_PROD.ORIGEM_PRODUTO=3 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR A  40% ATE 70%'
                    WHEN EST_PROD.ORIGEM_PRODUTO=4 THEN 
                            'NACIONAL, CUJA PRODUO TENHA SIDO FEITA EM CONFORMIDADE COM OS PROCESSOS PRODUTIVOS BSICOS DE QUE TRATAM O DECRETO-LEI N 288/67, E AS LEIS NS 8.248/91, 8.387/91, 10.176/01 E 11.484/07'
                    WHEN EST_PROD.ORIGEM_PRODUTO=5 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO INFERIOR OU IGUAL A 40% (QUARENTA POR CENTO)'
                    WHEN EST_PROD.ORIGEM_PRODUTO=6 THEN 
                            'ESTRANGEIRA - IMPORTAO DIRETA, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                    WHEN EST_PROD.ORIGEM_PRODUTO=7 THEN 
                            'ESTRANGEIRA - ADQUIRIDA NO MERCADO INTERNO, SEM SIMILAR NACIONAL, CONSTANTE EM LISTA DE RESOLUO CAMEX'
                    WHEN EST_PROD.ORIGEM_PRODUTO=8 THEN 
                            'NACIONAL, MERCADORIA OU BEM COM CONTEDO DE IMPORTAO SUPERIOR 70%'
                    ELSE 
                            'NAO DEFINIDO'
                    END,
                    MODALI_BASE_ICMS_SUBST      = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE MODALI_BASE_ICMS_SUBST END,
                    DS_MODALI_BASE_ICMS_SUBST   = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN '' ELSE DS_MODALI_BASE_ICMS_SUBST END,
                    PRECO_BASE_SUBS             = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PRECO_BASE_SUBS END, 
                    PERC_REDU_PMC_FORN          = CASE WHEN EST_TRIB.SUBS_TRIB=0 THEN 0 ELSE PERC_REDU_PMC_FORN END ,
                    ICMS_DESONERADO 			= ISNULL(EST_TRIB.ICMS_DESONERADO, 0),
				    MOTIVO_DESONERADO_ICMS      = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.MOTIVO_DESONERADO_ICMS ELSE 0 END ,                 
			        CD_BENEF                    = CASE WHEN EST_TRIB.ICMS_DESONERADO =1 THEN TBL_TRIB_PROD.CD_BENEF ELSE '' END                  
                FROM 
                    @TBL_TRIB_PROD TBL_TRIB_PROD
                    INNER JOIN EST_PROD ON 
                    TBL_TRIB_PROD.CD_EMP      = EST_PROD.CD_EMP               
                    AND TBL_TRIB_PROD.CD_PROD = EST_PROD.CD_PROD
                    INNER JOIN EST_TRIB ON 
                    TBL_TRIB_PROD.CD_TRIB_CST                = EST_TRIB.CD_TRIB_CST                          
                    --AND ISNULL(EST_PROD.ORIGEM_PRODUTO,0)   = EST_TRIB.ORIGEM_PRODUTO                               
                WHERE 
                    EST_TRIB.TIPO_REGIME_EMPRESA = 1
                    AND TBL_TRIB_PROD.TIPO_REGIME_EMPRESA_GRUPO_TRIB=1
            END
        END     
----------------------------------------------------------------------------------------------------------------
--ATRIBUINDO O PERCENTUAL DE ICMS PARA OS DEMAIS PRODUTOS 
----------------------------------------------------------------------------------------------------------------
        IF @TP_MOV_OP_TRANSA = 0     
        BEGIN
            UPDATE @TBL_TRIB_PROD
                    SET  PERC_ICMS = ISNULL((SELECT ALIQ_ICMS 
                                                FROM EST_TRIB_ALIQ_ICMS 
                                                WHERE UF_ORIG          = @UF_DEST_ORIG 
                                                        AND UF_DEST  = @UF_FILIAL),0)  
            WHERE PERC_ICMS = 0
            SET @ALIQ_ICMS_UF_DEST = ISNULL((SELECT ALIQ_ICMS 
                                                FROM EST_TRIB_ALIQ_ICMS 
                                                WHERE UF_ORIG          = @UF_FILIAL 
                                                        AND UF_DEST  = @UF_FILIAL),0) 
        END
        ELSE                                                                      
        BEGIN
            UPDATE @TBL_TRIB_PROD
            SET  PERC_ICMS = ISNULL((SELECT ALIQ_ICMS 
                                                FROM EST_TRIB_ALIQ_ICMS 
                                                WHERE UF_ORIG          = @UF_FILIAL 
                                                        AND UF_DEST  = @UF_DEST_ORIG),0) 
            WHERE PERC_ICMS = 0
            SET @ALIQ_ICMS_UF_DEST = ISNULL((SELECT ALIQ_ICMS 
                                                    FROM EST_TRIB_ALIQ_ICMS 
                                                    WHERE UF_ORIG          = @UF_DEST_ORIG 
                                                            AND UF_DEST  = @UF_DEST_ORIG),0)                                                                                
        END
----------------------------------------------------------------------------------------------------------------
--DEFININDO A ALIQUOTA DE ICMS INTERNA PARA OPERACOES QUE N?O ST
------------------------------------------------------------------------------------------------------------------
    UPDATE @TBL_TRIB_PROD 
    SET
        PERC_ICMS_EST= PERC_ICMS            
    WHERE 
        PERC_ICMS_EST= 0
        AND SUBS_TRIB = 0 
        AND SUBS_TRIB_ANT= 0;
----------------------------------------------------------------------------------------------------------------
--DEFININDO A ALIQUOTA DE ICMS INTERNA
----------------------------------------------------------------------------------------------------------------
    UPDATE 
        @TBL_TRIB_PROD 
    SET
        PERC_ICMS_EST= @ALIQ_ICMS_UF_DEST            
    WHERE 
        PERC_ICMS_EST= 0;
----------------------------------------------------------------------------------------------------------------
--ALIQUOTA DE SIMPLES NACIONAL
----------------------------------------------------------------------------------------------------------------
IF  @FILIAL_OPTANTE_SIMPLES_NACIONAL=1 AND @TP_MOV_OP_TRANSA = 1
BEGIN
   UPDATE 
        @TBL_TRIB_PROD 
    SET
        PERC_ICMS_EST= @PERC_ALIQ_SN,
        PERC_ICMS=@PERC_ALIQ_SN 
    WHERE    
        PERC_ICMS>0
        AND @PERC_ALIQ_SN > 0 AND @FLAG_ALIQ_ICMS_CONFIG_PRODUTO = 0
END
----------------------------------------------------------------------------------------------------------------
--BUSCANDO A LIQUOTA INTERNA DE VENDA DO ESTOQUE DE ORIGEM
----------------------------------------------------------------------------------------------------------------
UPDATE
    T
SET 
     T.PERC_ICMS_ORIGEM_DIFAL=CASE WHEN T.PERC_ICMS_ORIGEM_DIFAL=0 THEN AL.ALIQ_ICMS ELSE T.PERC_ICMS_ORIGEM_DIFAL END
FROM
    @TBL_TRIB_PROD T INNER JOIN EST_TRIB_ALIQ_ICMS AL ON
    T.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS = AL.UF_DEST COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AND
    T.UF_FILIAL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS = AL.UF_ORIG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
----------------------------------------------------------------------------------------------------------------
--BUSCANDO A LIQUOTA INTERNA DE VENDA DO ESTOQUE DE DESTINO
----------------------------------------------------------------------------------------------------------------
IF ( @TP_MOV  IN  (0, 3, 27, 65) ) AND @UF_FILIAL <> @UF_DEST_ORIG
    BEGIN
       UPDATE
           T
       SET 
            T.PERC_ICMS_DESTINO_DIFAL=CASE WHEN T.PERC_ICMS_DESTINO_DIFAL = 0 THEN AL.ALIQ_ICMS ELSE T.PERC_ICMS_DESTINO_DIFAL END,
            T.GERAR_DIFAL= CASE WHEN @CONTRIBUINTE IN (0,9) AND (T.ICMS) =1  THEN --0 - NAO DEFINIDO, 9 - NAO CONTRIBUINTE
                               CASE WHEN  T.PERC_ICMS_ORIGEM_DIFAL < AL.ALIQ_ICMS THEN
                                   1 
                               ELSE
                                   0
                               END 
                           ELSE
                               0
                           END 
       FROM
           @TBL_TRIB_PROD T INNER JOIN EST_TRIB_ALIQ_ICMS AL ON
           T.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS = AL.UF_DEST COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AND
           T.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS = AL.UF_ORIG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
    END
----------------------------------------------------------------------------------------------------------------
--VERIFICANDO OS PRODUTOS IMPORTADOS PARA FIXAR A ALIQUOTA PADRAO
----------------------------------------------------------------------------------------------------------------
    IF @UF_FILIAL <> @UF_DEST_ORIG
    BEGIN
        UPDATE 
            @TBL_TRIB_PROD            
        SET
            PERC_ICMS = @PERC_ALIQ_ICMS_IMPORTACAO,
            PERC_ICMS_EST=(CASE WHEN SUBS_TRIB = 1 THEN PERC_ICMS_EST ELSE @PERC_ALIQ_ICMS_IMPORTACAO END),
            PERC_RED = PERC_RED_IMPORTADO,
            PERC_RED_SUBS_TRIB = PERC_RED_SUBS_TRIB_IMPORTADO,
            PERC_ICMS_ORIGEM_DIFAL=@PERC_ALIQ_ICMS_IMPORTACAO
        WHERE 
            ORIGEM_PRODUTO IN (1,2,3,8) 
    END
    IF @UF_FILIAL = @UF_DEST_ORIG
    BEGIN
        UPDATE 
            @TBL_TRIB_PROD            
        SET
            PERC_RED = PERC_RED_IMPORTADO,
            PERC_RED_SUBS_TRIB = PERC_RED_SUBS_TRIB_IMPORTADO
        WHERE 
            ORIGEM_PRODUTO IN (1,2,3,8) 
    END
----------------------------------------------------------------------------------------------------------------
--ZERANDO ALIQUOTA QUANDO O PRODUTO FOR ISENTO E DEFININDO ALIQUOTA DE ICMS DISONERADO
----------------------------------------------------------------------------------------------------------------
    UPDATE 
        @TBL_TRIB_PROD 
    SET
        PERC_ICMS_DESONERADO= PERC_ICMS_EST+PERC_ALIQ_FECOP 
    WHERE ICMS_DESONERADO=1
    UPDATE 
        @TBL_TRIB_PROD 
    SET
        PERC_ICMS_EST= 0,
        PERC_ICMS=0
    WHERE 
        ISENTO=1;
----------------------------------------------------------------------------------------------------------------
--DEFININDO A ALIQUOTA DE ICMS INTERNA QUANDO FOR PARA GERAR ICMS RETIDO
----------------------------------------------------------------------------------------------------------------
IF @FLAG_GERAR_ICMS_RETIDO=1 AND @TP_MOV_OP_TRANSA = 0 
    BEGIN
        UPDATE 
            @TBL_TRIB_PROD 
        SET
            PERC_ICMS = CASE WHEN PERC_ICMS_EST > 0 THEN PERC_ICMS_EST ELSE PERC_ICMS END
        WHERE
            SUBS_TRIB_ANT=1
    END    
--NAO GERANDO ICMS RETIDO ENTAO ZERA    
IF @FLAG_GERAR_ICMS_RETIDO=0  
    BEGIN
        UPDATE 
            @TBL_TRIB_PROD 
        SET
            PERC_ICMS = 0,
            PERC_ICMS_EST =0
        WHERE
            SUBS_TRIB_ANT=1
    END    
----------------------------------------------------------------------------------------------------------------
--ATUALIZANDO O MVA, PAUTA, PMC E CARGA TRIBUTARIA PARA OS PRODUTOS ST CUJO GRUPO POSSUA VINCULO COM A TABELA DE MVA
----------------------------------------------------------------------------------------------------------------
        IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT=1))                          
        BEGIN
            --SE N?O ESTIVER OPERACAO DE MVA OU O PRODUTO FOR IMPORTADO COM TRANSACAO FORA DO ESTADO DEVE-SE PEGAR O MVA PELA ALIQUOTA.
            -----------------------------------------------------------------------------------------------------------------------------------------
            IF @CD_OPER_MVA = 0 OR EXISTS (SELECT CD_EMP 
                                           FROM @TBL_TRIB_PROD 
                                           WHERE ORIGEM_PRODUTO IN (1,2,3,8) AND @UF_FILIAL <> @UF_DEST_ORIG) 
                BEGIN           
                    UPDATE 
                        TBL_TRIB_PROD 
                    SET
                        TP_SUBS         = ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS),                                          
                        CD_TBL_MVA      = ISNULL(EXCECAO_MVA_CPL.CD_TBL_MVA, MVA_CPL.CD_TBL_MVA),
                        VLR_PAUTA_IVA_ORIGINAL=ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                        VLR_PAUTA_IVA = ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                        EXCECAO_MVA_PRODUTO =ISNULL(EXCECAO.FLAG_TBL_MVA_EXCECAO, MVA.FLAG_TBL_MVA_EXCECAO)
                    FROM 
                        @TBL_TRIB_PROD TBL_TRIB_PROD
                        INNER JOIN EST_TRIB_ALIQ_MVA_EST_TRIB_CONF_GRP GRP_MVA ON
                        TBL_TRIB_PROD.CD_EMP              = GRP_MVA.CD_EMP
                        AND TBL_TRIB_PROD.CD_CTR          = GRP_MVA.CD_CTR
                        INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                        MVA.CD_EMP                        = GRP_MVA.CD_EMP
                        AND MVA.CD_TBL_MVA                = GRP_MVA.CD_TBL_MVA  
                        AND MVA.FLAG_TBL_MVA_EXCECAO       = 0                        
                        INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
                        MVA_CPL.CD_EMP                    = MVA.CD_EMP
                        AND MVA_CPL.CD_TBL_MVA            = MVA.CD_TBL_MVA
                        INNER JOIN EST_TRIB_OPER_MVA ON 
                        MVA_CPL.CD_OPER_MVA = EST_TRIB_OPER_MVA.CD_OPER_MVA                         
                        AND EST_TRIB_OPER_MVA.TP_OPER     = 1
                        AND EST_TRIB_OPER_MVA.ALIQ_OPER   = TBL_TRIB_PROD.PERC_ICMS --ATENCAO: A BUSCO DO MVA DEVE SER SEMPRE PELA ALIQUOTA DO DESTINO. NAO MUDAR ISTO 
                        LEFT OUTER JOIN EST_PROD_EST_TRIB_CONF_GRP_EST_TRIB_ALIQ_MVA EXCECAO_ALIQ_MVA ON  
                         TBL_TRIB_PROD.CD_EMP = EXCECAO_ALIQ_MVA.CD_EMP AND
                         TBL_TRIB_PROD.CD_PROD = EXCECAO_ALIQ_MVA.CD_PROD AND 
                         TBL_TRIB_PROD.CD_REGIAO_FISCAL = EXCECAO_ALIQ_MVA.CD_REGIAO_FISCAL
                        LEFT OUTER JOIN EST_TRIB_ALIQ_MVA EXCECAO ON 
                        EXCECAO.CD_EMP            = TBL_TRIB_PROD.CD_EMP
                        AND EXCECAO.TP_LISTA        = TBL_TRIB_PROD.TP_LISTA                                                        
                        AND EXCECAO.CD_CLASS_FISC   = TBL_TRIB_PROD.CD_CLASS_FISC                                                   
                        AND EXCECAO.CD_REGIAO_FISCAL= TBL_TRIB_PROD.CD_REGIAO_FISCAL  
                        AND EXCECAO.CD_TBL_MVA        = EXCECAO_ALIQ_MVA.CD_TBL_MVA
                        AND EXCECAO.FLAG_TBL_MVA_EXCECAO = 1                                            
                        LEFT OUTER JOIN EST_TRIB_OPER_MVA EXCECAO_TRIB_OPER_MVA ON                         
                        EXCECAO_TRIB_OPER_MVA.TP_OPER   = 1
                        AND EXCECAO_TRIB_OPER_MVA.ALIQ_OPER = TBL_TRIB_PROD.PERC_ICMS --ATENCAO: A BUSCO DO MVA DEVE SER SEMPRE PELA ALIQUOTA DO DESTINO. NAO MUDAR ISTO  
                        LEFT OUTER JOIN EST_TRIB_ALIQ_MVA_CPL EXCECAO_MVA_CPL ON 
                        EXCECAO.CD_EMP                = EXCECAO_MVA_CPL.CD_EMP AND
                        EXCECAO.CD_TBL_MVA            = EXCECAO_MVA_CPL.CD_TBL_MVA AND
                        EXCECAO_MVA_CPL.CD_OPER_MVA    = EXCECAO_TRIB_OPER_MVA.CD_OPER_MVA                         
                        AND EXCECAO_MVA_CPL.UF_DEST  = @UF_DEST_ORIG
                    WHERE                           
                        MVA_CPL.UF_DEST                  = @UF_DEST_ORIG 
                        AND (TBL_TRIB_PROD.SUBS_TRIB    = 1 OR SUBS_TRIB_ANT=1)                    
                        AND MVA.TP_TRANSA IN (@TP_MOV_OP_TRANSA, 2)
                        AND (@CD_OPER_MVA = 0 OR TBL_TRIB_PROD.ORIGEM_PRODUTO IN (1,2,3,8))                        
                        AND ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) = (CASE WHEN @FLAG_GERA_DARE_SIMULADO = 1 THEN 
                                                                                    @TP_SUBS_SIMULADO 
                                                                                ELSE 
                                                                                    ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) 
                                                                                END)
                END     
            --SE ESTIVER OPERACAO DE MVA APLICA O MVA CONFORME A OPERACAO
            -----------------------------------------------------------------------------------------------------------------------------------------
            IF @CD_OPER_MVA <> 0
                BEGIN
                    UPDATE 
                        TBL_TRIB_PROD 
                    SET
                        TP_SUBS         = ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS),                                          
                        CD_TBL_MVA      = ISNULL(EXCECAO_MVA_CPL.CD_TBL_MVA, MVA_CPL.CD_TBL_MVA),
                        VLR_PAUTA_IVA_ORIGINAL=ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                        VLR_PAUTA_IVA = ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                        EXCECAO_MVA_PRODUTO =ISNULL(EXCECAO.FLAG_TBL_MVA_EXCECAO, MVA.FLAG_TBL_MVA_EXCECAO)
                    FROM 
                        @TBL_TRIB_PROD TBL_TRIB_PROD
                        INNER JOIN EST_TRIB_ALIQ_MVA_EST_TRIB_CONF_GRP GRP_MVA ON
                        TBL_TRIB_PROD.CD_EMP            = GRP_MVA.CD_EMP
                        AND TBL_TRIB_PROD.CD_CTR        = GRP_MVA.CD_CTR
                        INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                        MVA.CD_EMP                      = GRP_MVA.CD_EMP
                        AND MVA.CD_TBL_MVA              = GRP_MVA.CD_TBL_MVA
                        AND MVA.FLAG_TBL_MVA_EXCECAO    = 0
                        INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
                        MVA_CPL.CD_EMP                  = MVA.CD_EMP
                        AND MVA_CPL.CD_TBL_MVA          = MVA.CD_TBL_MVA
                        AND MVA_CPL.CD_OPER_MVA         = @CD_OPER_MVA                                                         
                        AND MVA_CPL.UF_DEST             = @UF_DEST_ORIG
                        LEFT OUTER JOIN EST_PROD_EST_TRIB_CONF_GRP_EST_TRIB_ALIQ_MVA EXCECAO_ALIQ_MVA ON  
                         TBL_TRIB_PROD.CD_EMP = EXCECAO_ALIQ_MVA.CD_EMP AND
                         TBL_TRIB_PROD.CD_PROD = EXCECAO_ALIQ_MVA.CD_PROD AND 
                         TBL_TRIB_PROD.CD_REGIAO_FISCAL = EXCECAO_ALIQ_MVA.CD_REGIAO_FISCAL
                        LEFT OUTER JOIN EST_TRIB_ALIQ_MVA EXCECAO ON 
                        EXCECAO.CD_EMP            = TBL_TRIB_PROD.CD_EMP
                        AND EXCECAO.TP_LISTA        = TBL_TRIB_PROD.TP_LISTA                                                        
                        AND EXCECAO.CD_CLASS_FISC   = TBL_TRIB_PROD.CD_CLASS_FISC                                                   
                        AND EXCECAO.CD_REGIAO_FISCAL= TBL_TRIB_PROD.CD_REGIAO_FISCAL  
                        AND EXCECAO.CD_TBL_MVA        = EXCECAO_ALIQ_MVA.CD_TBL_MVA
                        AND EXCECAO.FLAG_TBL_MVA_EXCECAO = 1
                        LEFT OUTER JOIN EST_TRIB_ALIQ_MVA_CPL EXCECAO_MVA_CPL ON 
                        EXCECAO.CD_EMP                = EXCECAO_MVA_CPL.CD_EMP AND
                        EXCECAO.CD_TBL_MVA            = EXCECAO_MVA_CPL.CD_TBL_MVA  
                        AND EXCECAO_MVA_CPL.CD_OPER_MVA  = @CD_OPER_MVA 
                        AND EXCECAO_MVA_CPL.UF_DEST  = @UF_DEST_ORIG
                    WHERE 
                        (TBL_TRIB_PROD.SUBS_TRIB      = 1
                        OR SUBS_TRIB_ANT=1)
                        AND MVA.TP_TRANSA  IN (@TP_MOV_OP_TRANSA, 2)
                        AND TBL_TRIB_PROD.CD_TBL_MVA = 0                        
                        AND ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) = (CASE WHEN @FLAG_GERA_DARE_SIMULADO = 1 THEN 
                                                                                    @TP_SUBS_SIMULADO 
                                                                                ELSE 
                                                                                    ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) 
                                                                                END)
                END     
        END                                             
----------------------------------------------------------------------------------------------------------------
--ATUALIZANDO O MVA, PAUTA, PMC E CARGA TRIBUTARIA PARA OS PRODUTOS ST CUJO GRUPO NAO POSSUA VINCULO COM A TABELA DE MVA
----------------------------------------------------------------------------------------------------------------
        IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT=1) AND CD_TBL_MVA = 0)                       
            BEGIN
                --SE N?O ESTIVER OPERACAO DE MVA OU O PRODUTO FOR IMPORTADO COM TRANSACAO FORA DO ESTADO DEVE-SE PEGAR O MVA PELA ALIQUOTA.
                -----------------------------------------------------------------------------------------------------------------------------------------
                IF @CD_OPER_MVA = 0 OR EXISTS (SELECT CD_EMP 
                                               FROM @TBL_TRIB_PROD 
                                               WHERE ORIGEM_PRODUTO IN (1,2,3,8) AND @UF_FILIAL <> @UF_DEST_ORIG)
                    BEGIN           
                        UPDATE 
                            TBL_TRIB_PROD 
                        SET
                            TP_SUBS         = ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS),                                          
                            CD_TBL_MVA    = ISNULL(EXCECAO_MVA_CPL.CD_TBL_MVA, MVA_CPL.CD_TBL_MVA),
                            VLR_PAUTA_IVA_ORIGINAL=ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                            VLR_PAUTA_IVA = ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                            EXCECAO_MVA_PRODUTO =ISNULL(EXCECAO.FLAG_TBL_MVA_EXCECAO, MVA.FLAG_TBL_MVA_EXCECAO)
                        FROM 
                            @TBL_TRIB_PROD TBL_TRIB_PROD
                            INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                            MVA.CD_EMP            = TBL_TRIB_PROD.CD_EMP
                            AND MVA.TP_LISTA        = TBL_TRIB_PROD.TP_LISTA                                                        
                            AND MVA.CD_CLASS_FISC   = TBL_TRIB_PROD.CD_CLASS_FISC                                                   
                            AND MVA.CD_REGIAO_FISCAL= TBL_TRIB_PROD.CD_REGIAO_FISCAL    
                            AND MVA.FLAG_TBL_MVA_EXCECAO = 0  
                            INNER JOIN EST_TRIB_ALIQ_MVA_NCM MVA_NCM ON     
                            MVA.CD_EMP              = MVA_NCM.CD_EMP
                            AND MVA.CD_TBL_MVA      = MVA_NCM.CD_TBL_MVA
                            AND MVA_NCM.NR_NCM      = TBL_TRIB_PROD.NR_NCM  COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
                            INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
                            MVA_CPL.CD_EMP          = MVA.CD_EMP
                            AND MVA_CPL.CD_TBL_MVA  = MVA.CD_TBL_MVA
                            INNER JOIN EST_TRIB_OPER_MVA ON 
                            MVA_CPL.CD_OPER_MVA    = EST_TRIB_OPER_MVA.CD_OPER_MVA                         
                            AND EST_TRIB_OPER_MVA.TP_OPER   = 1
                            AND EST_TRIB_OPER_MVA.ALIQ_OPER = TBL_TRIB_PROD.PERC_ICMS --ATENCAO: A BUSCO DO MVA DEVE SER SEMPRE PELA ALIQUOTA DO DESTINO. NAO MUDAR ISTO 
                            LEFT OUTER JOIN EST_PROD_EST_TRIB_CONF_GRP_EST_TRIB_ALIQ_MVA EXCECAO_ALIQ_MVA ON  
                            TBL_TRIB_PROD.CD_EMP = EXCECAO_ALIQ_MVA.CD_EMP AND
                            TBL_TRIB_PROD.CD_PROD = EXCECAO_ALIQ_MVA.CD_PROD AND 
                            TBL_TRIB_PROD.CD_REGIAO_FISCAL = EXCECAO_ALIQ_MVA.CD_REGIAO_FISCAL
                            LEFT OUTER JOIN EST_TRIB_ALIQ_MVA EXCECAO ON 
                            EXCECAO.CD_EMP            = TBL_TRIB_PROD.CD_EMP
                            AND EXCECAO.TP_LISTA        = TBL_TRIB_PROD.TP_LISTA                                                        
                            AND EXCECAO.CD_CLASS_FISC   = TBL_TRIB_PROD.CD_CLASS_FISC                                                   
                            AND EXCECAO.CD_REGIAO_FISCAL= TBL_TRIB_PROD.CD_REGIAO_FISCAL  
                            AND EXCECAO.CD_TBL_MVA        = EXCECAO_ALIQ_MVA.CD_TBL_MVA
                            AND EXCECAO.FLAG_TBL_MVA_EXCECAO = 1                                            
                            LEFT OUTER JOIN EST_TRIB_OPER_MVA EXCECAO_TRIB_OPER_MVA ON                         
                            EXCECAO_TRIB_OPER_MVA.TP_OPER   = 1
                            AND EXCECAO_TRIB_OPER_MVA.ALIQ_OPER = TBL_TRIB_PROD.PERC_ICMS --ATENCAO: A BUSCO DO MVA DEVE SER SEMPRE PELA ALIQUOTA DO DESTINO. NAO MUDAR ISTO  
                            LEFT OUTER JOIN EST_TRIB_ALIQ_MVA_CPL EXCECAO_MVA_CPL ON 
                            EXCECAO.CD_EMP                = EXCECAO_MVA_CPL.CD_EMP AND
                            EXCECAO.CD_TBL_MVA            = EXCECAO_MVA_CPL.CD_TBL_MVA AND
                            EXCECAO_MVA_CPL.CD_OPER_MVA    = EXCECAO_TRIB_OPER_MVA.CD_OPER_MVA                         
                            AND EXCECAO_MVA_CPL.UF_DEST  = @UF_DEST_ORIG
                        WHERE   
                            MVA.CD_REGIAO_FISCAL        = @CD_REGIAO_FISCAL                     
                            AND MVA_CPL.UF_DEST         = @UF_DEST_ORIG 
                            AND (TBL_TRIB_PROD.SUBS_TRIB      = 1
                            OR SUBS_TRIB_ANT=1)
                            AND TBL_TRIB_PROD.CD_TBL_MVA= 0 
                            AND MVA.TP_TRANSA IN (@TP_MOV_OP_TRANSA, 2)
                            AND (@CD_OPER_MVA = 0 OR TBL_TRIB_PROD.ORIGEM_PRODUTO IN (1,2,3,8))                            
                            AND ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) = (CASE WHEN @FLAG_GERA_DARE_SIMULADO = 1 THEN 
                                                                                        @TP_SUBS_SIMULADO 
                                                                                    ELSE 
                                                                                        ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) 
                                                                                    END)                                
                    END     
                IF @CD_OPER_MVA <> 0
                    BEGIN
                        UPDATE 
                            TBL_TRIB_PROD 
                        SET
                            TP_SUBS         = ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS),                                            
                            CD_TBL_MVA      = ISNULL(EXCECAO_MVA_CPL.CD_TBL_MVA, MVA_CPL.CD_TBL_MVA),
                            VLR_PAUTA_IVA_ORIGINAL=ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                            VLR_PAUTA_IVA = ISNULL(EXCECAO_MVA_CPL.ALIQ_MVA, MVA_CPL.ALIQ_MVA),
                            EXCECAO_MVA_PRODUTO =ISNULL(EXCECAO.FLAG_TBL_MVA_EXCECAO, MVA.FLAG_TBL_MVA_EXCECAO)
                        FROM 
                            @TBL_TRIB_PROD TBL_TRIB_PROD
                            INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                            MVA.CD_EMP                          = TBL_TRIB_PROD.CD_EMP
                            AND MVA.TP_LISTA                    = TBL_TRIB_PROD.TP_LISTA                                                   
                            AND MVA.CD_CLASS_FISC               = TBL_TRIB_PROD.CD_CLASS_FISC
                            AND MVA.FLAG_TBL_MVA_EXCECAO         = 0
                            INNER JOIN EST_TRIB_ALIQ_MVA_NCM MVA_NCM ON     
                            MVA.CD_EMP                          = MVA_NCM.CD_EMP
                            AND MVA.CD_TBL_MVA                  = MVA_NCM.CD_TBL_MVA
                            AND MVA_NCM.NR_NCM                  = TBL_TRIB_PROD.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS                     
                            INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
                            MVA_CPL.CD_EMP                      = MVA.CD_EMP
                            AND MVA_CPL.CD_TBL_MVA              = MVA.CD_TBL_MVA
                            AND MVA_CPL.CD_OPER_MVA             = @CD_OPER_MVA
                            AND MVA_CPL.UF_DEST                 = @UF_DEST_ORIG
                            LEFT OUTER JOIN EST_PROD_EST_TRIB_CONF_GRP_EST_TRIB_ALIQ_MVA EXCECAO_ALIQ_MVA ON  
                             TBL_TRIB_PROD.CD_EMP = EXCECAO_ALIQ_MVA.CD_EMP AND
                              TBL_TRIB_PROD.CD_PROD = EXCECAO_ALIQ_MVA.CD_PROD AND 
                              TBL_TRIB_PROD.CD_REGIAO_FISCAL = EXCECAO_ALIQ_MVA.CD_REGIAO_FISCAL
                            LEFT OUTER JOIN EST_TRIB_ALIQ_MVA EXCECAO ON 
                            EXCECAO.CD_EMP                = TBL_TRIB_PROD.CD_EMP
                            AND EXCECAO.TP_LISTA        = TBL_TRIB_PROD.TP_LISTA                                                        
                            AND EXCECAO.CD_CLASS_FISC   = TBL_TRIB_PROD.CD_CLASS_FISC                                                   
                            AND EXCECAO.CD_REGIAO_FISCAL= TBL_TRIB_PROD.CD_REGIAO_FISCAL  
                            AND EXCECAO.CD_TBL_MVA        = EXCECAO_ALIQ_MVA.CD_TBL_MVA
                            AND EXCECAO.FLAG_TBL_MVA_EXCECAO = 1
                            LEFT OUTER JOIN EST_TRIB_ALIQ_MVA_CPL EXCECAO_MVA_CPL ON 
                            EXCECAO.CD_EMP                = EXCECAO_MVA_CPL.CD_EMP AND
                            EXCECAO.CD_TBL_MVA            = EXCECAO_MVA_CPL.CD_TBL_MVA  
                            AND EXCECAO_MVA_CPL.CD_OPER_MVA  = @CD_OPER_MVA 
                            AND EXCECAO_MVA_CPL.UF_DEST  = @UF_DEST_ORIG
                        WHERE 
                            MVA.CD_REGIAO_FISCAL  = @CD_REGIAO_FISCAL                     
                            AND (TBL_TRIB_PROD.SUBS_TRIB = 1
                            OR SUBS_TRIB_ANT=1)
                            AND TBL_TRIB_PROD.CD_TBL_MVA  = 0 
                            AND MVA.TP_TRANSA IN (@TP_MOV_OP_TRANSA, 2)
                            AND TBL_TRIB_PROD.CD_TBL_MVA = 0
                            AND ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) = (CASE WHEN @FLAG_GERA_DARE_SIMULADO = 1 THEN 
                                                                                        @TP_SUBS_SIMULADO 
                                                                                    ELSE 
                                                                                        ISNULL(EXCECAO_MVA_CPL.TP_SUBS, MVA_CPL.TP_SUBS) 
                                                                                    END)                            
                    END     
            END
----------------------------------------------------------------------------------------------------------------
--GARANTINDO QUE N?O SER? RETORNANDO TRIBUTACAO POR DARE QUE NAO SEJA O SIMULADO
----------------------------------------------------------------------------------------------------------------            
        IF @FLAG_GERA_DARE_SIMULADO = 1
            BEGIN 
                DELETE TBL_TRIB_PROD 
                FROM @TBL_TRIB_PROD TBL_TRIB_PROD
                WHERE TP_SUBS <> @TP_SUBS_SIMULADO
            END
----------------------------------------------------------------------------------------------------------------
--REMOVENDO PRODUTOS COM ICMS SUBSTITUICAO QUE NAO POSSUI UMA TABELA DE MVA
----------------------------------------------------------------------------------------------------------------
        DELETE FROM @TBL_TRIB_PROD 
        WHERE SUBS_TRIB = 1 
            AND CD_TBL_MVA = 0
----------------------------------------------------------------------------------------------------------------
--ATUALIZANDO O PMC PARA AS TRIBUTACOES QUE UTILIZA O PMC NO CALCULO DA ST
----------------------------------------------------------------------------------------------------------------
--NATUREZA NAO E COMPLEMENTAR
IF @FLAG_NF_CPL=0
BEGIN  

        UPDATE 
            TBL_TRIB_PROD 
        SET            
            VLR_PMC    = ISNULL(PMPF_CPL.VLR_PMPF,0),
			VLR_PAUTA_IVA_ORIGINAL    = ISNULL(PMPF_CPL.VLR_PMPF,0),
            VLR_PAUTA_IVA             = ISNULL(PMPF_CPL.VLR_PMPF,0)
		
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD  
			
	        INNER JOIN EST_PROD_PRECO_PMPF_CPL PMPF_CPL ON 
			TBL_TRIB_PROD.CD_PROD               = PMPF_CPL.CD_PROD
			
			INNER JOIN EST_PROD_PRECO_PMPF PMPF ON 
			PMPF.CD_CTR                   = PMPF_CPL.CD_CTR
			AND PMPF.STS_TBL = 0

        WHERE 
            TBL_TRIB_PROD.TP_SUBS         = 4
        
        -- Quando o produto estiver configurado como PMPF e no constar na lista de preos PMPF
		-- o clculo dever ser efetuado pelo MVA

		UPDATE 
			TBL_TRIB_PROD 
		SET			
			TP_SUBS	= 0
		FROM 
			@TBL_TRIB_PROD TBL_TRIB_PROD
 		
		WHERE 
			TBL_TRIB_PROD.TP_SUBS = 4
			AND  VLR_PMC= 0

        -------------------------------------------------------------------
        
        UPDATE 
            TBL_TRIB_PROD 
        SET            
            VLR_PAUTA_IVA_ORIGINAL    = ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0)),
            VLR_PAUTA_IVA             = ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0)),
            VLR_PMC                    = ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0))
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD
            LEFT OUTER JOIN V_EST_PROD_PRECO_TBL_PERC_ICMS PRECO_CPL ON 
            PRECO_CPL.CD_EMP                        = TBL_TRIB_PROD.CD_EMP                                               
            AND PRECO_CPL.CD_PROD                   = TBL_TRIB_PROD.CD_PROD            
            AND PRECO_CPL.PERC_ICMS                    = TBL_TRIB_PROD.PERC_ICMS_EST            
            LEFT OUTER JOIN V_EST_PROD_PRECO_TBL PRECO ON 
            PRECO.CD_EMP                        = TBL_TRIB_PROD.CD_EMP
            AND PRECO.CD_FILIAL                 = @CD_FILIAL                                                        
            AND PRECO.CD_PROD                   = TBL_TRIB_PROD.CD_PROD            
        WHERE 
            TBL_TRIB_PROD.TP_SUBS                = 3
            AND TBL_TRIB_PROD.CTR_PMC            = 1
            AND ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0))            > 0 
        --AJUSTE DE IVA    CASO O PRODUTO COM BASE DO PMC COM O VALOR PMC ZERADO OU FLAG CTR_PMC DESMARCADO.
        UPDATE 
            TBL_TRIB_PROD 
        SET            
            TP_SUBS    = 0
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD
            LEFT OUTER JOIN V_EST_PROD_PRECO_TBL_PERC_ICMS PRECO_CPL ON 
            PRECO_CPL.CD_EMP                        = TBL_TRIB_PROD.CD_EMP                                               
            AND PRECO_CPL.CD_PROD                   = TBL_TRIB_PROD.CD_PROD            
            AND PRECO_CPL.PERC_ICMS                    = TBL_TRIB_PROD.PERC_ICMS_EST
            LEFT OUTER JOIN V_EST_PROD_PRECO_TBL PRECO ON 
            PRECO.CD_EMP                        = TBL_TRIB_PROD.CD_EMP
            AND PRECO.CD_FILIAL                 = @CD_FILIAL                                                        
            AND PRECO.CD_PROD                   = TBL_TRIB_PROD.CD_PROD            
        WHERE 
            TBL_TRIB_PROD.TP_SUBS                = 3            
            AND 
            (ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0))            = 0 OR TBL_TRIB_PROD.CTR_PMC = 0)
        --CALCULANDO O VALOR DE GARANTIA DO ICMS ST SOMENTE PELA CARGA TRIBUT?RIA.
        UPDATE TBL_TRIB_PROD SET 
            VLR_PMC = ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0)),
            VLR_ICMS_SUBS_GARANTIR = (ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0)) * (PERC_PMC_ST_CARGA_TRIB / 100.00))
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD
                INNER JOIN EST_TRIB_ALIQ_MVA_PARAM ON 
                    TBL_TRIB_PROD.CD_EMP = EST_TRIB_ALIQ_MVA_PARAM.CD_EMP 
                    AND TBL_TRIB_PROD.CD_TBL_MVA = EST_TRIB_ALIQ_MVA_PARAM.CD_TBL_MVA
                LEFT OUTER JOIN V_EST_PROD_PRECO_TBL_PERC_ICMS PRECO_CPL ON 
                    PRECO_CPL.CD_EMP                        = TBL_TRIB_PROD.CD_EMP                                               
                    AND PRECO_CPL.CD_PROD                   = TBL_TRIB_PROD.CD_PROD            
                    AND PRECO_CPL.PERC_ICMS                    = TBL_TRIB_PROD.PERC_ICMS_EST                    
                INNER JOIN V_EST_PROD_PRECO_TBL PRECO ON 
                    PRECO.CD_EMP                        = TBL_TRIB_PROD.CD_EMP
                    AND PRECO.CD_FILIAL                 = @CD_FILIAL                                                        
                    AND PRECO.CD_PROD                   = TBL_TRIB_PROD.CD_PROD
        WHERE 
            TBL_TRIB_PROD.TP_SUBS = 2
            AND EST_TRIB_ALIQ_MVA_PARAM.FLAG_PERC_PMC_ST_CARGA_TRIB = 1    
            AND TBL_TRIB_PROD.CTR_PMC            = 1
            AND ISNULL(PRECO_CPL.VLR_VD, ISNULL(PRECO.VLR_VD,0))            > 0        
        --EXCLUINDO/ABORTANDO A TRIBUTACAO CASO SEJA POR CARGA TRIBUTARIA RESTRITA A SOMENTE PRODUTOS CONTROLADOS POR PMC E 
        --QUE NAO TENHA O VALOR PMC CADASTRADO PARA O PRODUTO.
        DELETE     
            TBL_TRIB_PROD
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD
                INNER JOIN EST_TRIB_ALIQ_MVA_PARAM ON 
                    TBL_TRIB_PROD.CD_EMP = EST_TRIB_ALIQ_MVA_PARAM.CD_EMP 
                    AND TBL_TRIB_PROD.CD_TBL_MVA = EST_TRIB_ALIQ_MVA_PARAM.CD_TBL_MVA
        WHERE 
            TBL_TRIB_PROD.TP_SUBS = 2
            AND EST_TRIB_ALIQ_MVA_PARAM.FLAG_EXIGE_PMC_ST_CARGA_TRIB = 1                
            AND TBL_TRIB_PROD.VLR_PMC                                 = 0                
END                
--NATUREZA E COMPLEMENTAR
IF @FLAG_NF_CPL=1
BEGIN
        UPDATE 
            TBL_TRIB_PROD 
        SET            
            TP_SUBS    = 0
        FROM 
            @TBL_TRIB_PROD TBL_TRIB_PROD    
        WHERE 
            TBL_TRIB_PROD.TP_SUBS = 3            
END    
--AJUSTE DE IVA    CASO ESTEJA MARCADO NO GRUPO DE TRIBUTACAO
    UPDATE 
        TBL_TRIB_PROD 
    SET
        VLR_PAUTA_IVA = (ROUND(((1+(VLR_PAUTA_IVA/100.00))*((1-(PERC_ICMS/100.00))/(1-(PERC_ICMS_EST/100.00))))-1,4))*100
    FROM 
        @TBL_TRIB_PROD TBL_TRIB_PROD
    WHERE                           
        TBL_TRIB_PROD.PERC_ICMS < TBL_TRIB_PROD.PERC_ICMS_EST
        AND TBL_TRIB_PROD.MVA_AJUSTADO=1
        AND TBL_TRIB_PROD.TIPO_REGIME_EMPRESA=@COD_REG_TRIB
--QUANDO INFORMAR A ALIQUOTA DE ICMS
--DA ULTIMA ENTRADA DO PRODUTO
IF @ALIQ_ICMS_ENTRADA > 0
BEGIN
    UPDATE 
        TBL_TRIB_PROD 
    SET
        VLR_PAUTA_IVA = (ROUND(((1+(VLR_PAUTA_IVA/100.00))*((1-(@ALIQ_ICMS_ENTRADA/100.00))/(1-(PERC_ICMS_EST/100.00))))-1,4))*100
    FROM 
        @TBL_TRIB_PROD TBL_TRIB_PROD
    WHERE                           
        TBL_TRIB_PROD.PERC_ICMS_EST > @ALIQ_ICMS_ENTRADA
        AND TBL_TRIB_PROD.MVA_AJUSTADO=1
        AND TBL_TRIB_PROD.TIPO_REGIME_EMPRESA=@COD_REG_TRIB    
        AND TBL_TRIB_PROD.VLR_PAUTA_IVA <> 0
END
----------------------------------------------------------------------------------------------------------------
--DEFININDO O TIPO DESCRICAO DE GERACAO DA SUBSTITUICAO
----------------------------------------------------------------------------------------------------------------
    UPDATE 
        @TBL_TRIB_PROD 
    SET
         DS_TP_SUBS= CASE WHEN SUBS_TRIB_ANT=0 THEN
                        CASE WHEN TP_SUBS=0 THEN 
                            '0 - MVA' 
                        WHEN TP_SUBS=1 THEN 
                            '1 - PAUTA'
                        WHEN TP_SUBS=2 THEN 
                            '2 - CARGA TRIB'
                        WHEN TP_SUBS=3 THEN 
                            '3 - PRECO PMC'
						WHEN TP_SUBS=4 THEN 
							'4 - PRECO PMPF'
                        ELSE 
                            'NAO DEFINIDO'
                        END
                    ELSE
                        'PAGO ANTERIORMENTE'
                    END,
        MODALI_BASE_ICMS_SUBST =  CASE WHEN SUBS_TRIB_ANT=0 THEN
                                    CASE WHEN TP_SUBS=3 THEN 
                                        0
                                    ELSE
                                        4
                                    END
                                  ELSE
                                    0
                                  END
    WHERE 
        SUBS_TRIB = 1 OR SUBS_TRIB_ANT=1 ; 
----------------------------------------------------------------------------------------------------------------
--VERIFICANDO SE TEM QUE GERAR DAR/GNRE/DARE
--POR ENQUANTO SOMENTE NAS ENTRADAS
----------------------------------------------------------------------------------------------------------------
IF @TP_MOV_OP_TRANSA=0
BEGIN
    UPDATE
        T
    SET 
         T.GERAR_DARE =1
    FROM
        @TBL_TRIB_PROD T 
    WHERE
        GERAR_SUBS_TRIB =1
        AND TP_SUBS_TRIB=1
        AND FLAG_GERAR_MOV_DARE=1
END
--FECOP---------------------------------------------------------------------------------------------------------
DECLARE @GERAR_FECOP INT
SET @GERAR_FECOP=0
--SAIDA DE PRODUTO PARA CONSUMIDOR FINAL
IF (@TP_MOV_OP_TRANSA=1 AND @CONTRIBUINTE=9)
BEGIN
       SET @GERAR_FECOP=1
END
ELSE 
BEGIN
    --ENTRADA DE NOTA FISCAL
    IF @TP_MOV_OP_TRANSA=0 
    BEGIN 
        --ENTRADA DE PRODUTO QUE NAO FOR FILIAL
        IF @DEST_ORIG <> 2
        BEGIN
            SET @GERAR_FECOP=1
        END
    END
END
-- QUANDO FOR ENTRADA E A FLAG_CONVERTE_CST_SIMPLES_NACIONAL_ENTRADA ESTIVER MARCADA E O FORNECEDOR FOR 
-- OPTANTE PELO SIMPLES, DAR ENTRADA COM O CST GRAVADO NO CAMPO DE PARA SIMPLES SPED DO CADASTRO DA CST 
IF @TP_MOV_OP_TRANSA =0 AND @FLAG_CONVERTE_CST_SN = 1 AND @FLAG_FORN_MICRO_EMPRESA =1
    BEGIN
       UPDATE  TBL_TRIB_PROD
       SET            
          TBL_TRIB_PROD.CD_TRIB_FC=  ISNULL(TRIB_FC_ELETRONICO,''),
          TBL_TRIB_PROD.CD_TRIB_CST=  ISNULL(TRIB_FC_ELETRONICO,'')
       FROM 
          @TBL_TRIB_PROD TBL_TRIB_PROD
          INNER JOIN EST_TRIB ON 
              TBL_TRIB_PROD.CD_TRIB = EST_TRIB.CD_TRIB
       WHERE 
          EST_TRIB.CD_TRIB = TBL_TRIB_PROD.CD_TRIB
          AND ISNULL(TRIB_FC_ELETRONICO,0) <> ''            
       UPDATE  TBL_TRIB_PROD
       SET            
          TBL_TRIB_PROD.CD_TRIB = EST_TRIB.CD_TRIB
       FROM 
          @TBL_TRIB_PROD TBL_TRIB_PROD
          INNER JOIN EST_TRIB ON 
          EST_TRIB.CD_TRIB_FC = TBL_TRIB_PROD.CD_TRIB_FC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
       WHERE 
            TBL_TRIB_PROD.CD_TRIB_FC <> ''
    END   
IF EXISTS ( SELECT 1 FROM @TBL_PROD A WHERE PROD_EXCESSAO_FECOP = 0 )
BEGIN
    IF @GERAR_FECOP =1
    BEGIN
        UPDATE 
            PROD 
        SET 
            PERC_ALIQ_FECOP = ISNULL(POBR.PERC_ALIQ,0),
            PERC_ICMS= PERC_ICMS  
         FROM @TBL_TRIB_PROD PROD INNER JOIN 
                       EST_PROD_NCM_CADASTRO_COMB_POBREZA POBR ON
                           PROD.NR_NCM = POBR.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AND
                           PROD.UF = POBR.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
    END
END
--SAIDA DE PRODUTO PARA NAO CONSUMIDOR FINAL QUE APLICA FCOP
IF (@TP_MOV_OP_TRANSA=1 AND @CONTRIBUINTE<>9)
BEGIN
    IF EXISTS ( SELECT 1 FROM @TBL_PROD A WHERE PROD_EXCESSAO_FECOP = 0 )
    BEGIN
        UPDATE 
            PROD 
        SET 
            PERC_ALIQ_FECOP = ISNULL(POBR.PERC_ALIQ,0),
            PERC_ICMS= PERC_ICMS  
         FROM @TBL_TRIB_PROD PROD INNER JOIN 
                       EST_PROD_NCM_CADASTRO_COMB_POBREZA POBR ON
                           PROD.NR_NCM = POBR.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AND
                           PROD.UF = POBR.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
        WHERE
            PROD.FCOP=1       
    END
END
--------------------------------------------------------------------------
--QUANDO EXISTIR INFORMAO PARA O PRODUTO, CST E TIPO MOVIMENTAO INFORMADO, SUBSTITUIR OS CAMPOS VINCULADOS NO CADASTRO DO PRODUTO


IF EXISTS ( SELECT 1 FROM @TBL_PROD A WHERE PROD_EXCESSAO_FECOP = 0 )
BEGIN
    IF @GERAR_FECOP =1
    BEGIN
        UPDATE 
            PROD 
        SET 
            PERC_ALIQ_FECOP = ISNULL(POBR.PERC_ALIQ,0),
            PERC_ICMS= PERC_ICMS  
         FROM @TBL_TRIB_PROD PROD INNER JOIN 
                       EST_PROD_NCM_CADASTRO_COMB_POBREZA POBR ON
                           PROD.NR_NCM = POBR.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AND
                           PROD.UF = POBR.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
    END
END

--GERANDO CFOP DO PRODUTO
----------------------------------------------------------------------------------------------------------------
--RETORNANDO TRIBUTACOES
----------------------------------------------------------------------------------------------------------------
        IF @CD_PROD=''
            BEGIN
                INSERT INTO @RS_RETURN (CD_ID
                                                , CD_EMP                            
                                                , CD_PROD                           
                                                , CD_CTR                            
                                                , CD_TRIB_CST                       
                                                , UF                                
                                                , UF_FILIAL                          
                                                , TP_MOV                            
                                                , TP_TRANSA                         
                                                , TP_LISTA                          
                                                , DS_TP_LISTA                          
                                                , NR_NCM                            
                                                , NR_CEST                           
                                                , CD_CLASS_FISC                     
                                                , DS_CLASS_FISC                      
                                                , PERC_RED                          
                                                , PERC_ICMS                         
                                                , TP_RED_BASE_IMP                   
                                                , PERC_RED_SUBS_TRIB                
                                                , PERC_RED_ESTORNO                  
                                                , PERC_REPASSE                      
                                                , PERC_IBPT                         
                                                , TP_GERACAO_DARE                   
                                                , FLAG_TRIB_DARE                    
                                                , VLR_PAUTA_IVA                     
                                                , TP_SUBS                           
                                                , DS_TP_SUBS                          
                                                , PERC_ICMS_EST                     
                                                , PERC_ICMS_ORIGEM                  
                                                , HIST                              
                                                , CD_TRIB                           
                                                , CD_TRIB_FC                        
                                                , ICMS                              
                                                , SUBS_TRIB                         
                                                , ICMS_RD                           
                                                , SUBS_TRIB_ANT                     
                                                , ISENTO                            
                                                , TIPO_REGIME_EMPRESA               
                                                , FLAG_VLR_SUBST_TOTAL_PROD          
                                                , FLAG_GERAR_ICMS_SUBS_DARE            
                                                , FLAG_OUTROS                       
                                                , ORIGEM_PRODUTO                    
                                                , DS_ORIGEM_PRODUTO                  
                                                , CD_TBL_MVA                        
                                                , CD_REGIAO_FISCAL                    
                                                , NM_REGIAO_FISCAL                    
                                                , VLR_PAUTA_IVA_ORIGINAL                
                                                , MVA_AJUSTADO                        
                                                , TIPO_TRIBUTACAO_PIS_COFINS            
                                                , SIGLA_EXCECAO_PIS_COFINS            
                                                , FLAG_EXCECAO_PIS_COFINS                
                                                , PIS_COFINS                            
                                                , FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP    
                                                , FLAG_TRIB_PIS_COFINS_PROD            
                                                , CTR_PMC                                
                                                , FLAG_GERAR_ICMS_RETIDO                
                                                , PERC_RED_IMPORTADO                  
                                                , PERC_RED_SUBS_TRIB_IMPORTADO        
                                                , TIPO_REGIME_EMPRESA_GRUPO_TRIB        
                                                , DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB   
                                                , TIPO_REGIME_DESTINATARIO_ORIGEM     
                                                , DS_TIPO_REGIME_DESTINATARIO_ORIGEM  
                                                , OBS_GRUPO_TRIB_NF                    
                                                , EXCECAO_MVA_PRODUTO                    
                                                , MODALI_BASE_ICMS_SUBST                
                                                , DS_MODALI_BASE_ICMS_SUBST            
                                                , PRECO_BASE_SUBS                        
                                                , PERC_REDU_PMC_FORN                  
                                                , TIPO_REGIME_FILIAL  
                                                , DS_TIPO_REGIME_FILIAL  
                                                , TRIBUTACAO_FORNECEDOR                
                                                , VLR_PMC                                
                                                , VLR_ICMS_SUBS_GARANTIR                
                                                , PERC_ICMS_DESTINO_DIFAL 
                                                , PERC_ICMS_ORIGEM_DIFAL     
                                                , GERAR_DIFAL                
                                                , GERAR_DAR                
                                                , CONTRIBUINTE            
                                                , FLAG_GERAR_MOV_DARE        
                                                , GERAR_SUBS_TRIB            
                                                , TP_SUBS_TRIB            
                                                , PERC_ALIQ_FECOP            
                                                , FLAG_FRETE_BASE_ICMS    
                                                , FCOP 
                                                , ICMS_DESONERADO  
                                                , MOTIVO_DESONERADO_ICMS   
                                                , VLR_ICMS_DESONERADO         
                                                , PERC_ICMS_DESONERADO    
                                                , CD_BENEF
                                                /**************** UFD_EST_PROD_TRIB_GERAR_IMPOSTO **********************/          
                                                , QT_PROD 
                                                , VLR_IT  
                                                , VLR_DESC_IT  
                                                , VLR_FRETE  
                                                , VLR_OUTROS  
                                                , VLR_IPI  
                                                , VLR_BASE_ICMS  
                                                , VLR_ICMS   
                                                , VLR_BASE_SUBS  
                                                , VLR_ICMS_SUBS  
                                                , VLR_BASE_ICMS_OP  
                                                , VLR_ICMS_OP            
                                                , VLR_BASE_RET        
                                                , VLR_ICMS_RET        
                                                , VLR_CUSTO            
                                                , VLR_REA                
                                                , VLR_BASE_FECOP        
                                                , VLR_BASE_FECOP_SUBS        
                                                , VLR_BASE_FECOP_RET        
                                                , VLR_FECOP                
                                                , VLR_FECOP_ST            
                                                , VLR_FECOP_RET        
                                                /******************************** UFD_MONTAR_CFOP ****************************************/    
                                                , CD_NT_OP                
                                                , CD_NT_OP_FC    
                                                /******************************** UFD_EST_PROD_TRIB_TESTE_PIS_COFINS ****************************************/            
                                                , CST_PIS                    
                                                , PERC_PIS                
                                                , VLR_BASE_PIS            
                                                , VLR_PIS                    
                                                , CST_COFINS
                                                , PERC_COFINS
                                                , VLR_BASE_COFINS
                                                , VLR_COFINS
                                                , MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS 
                                                , PROD_PIS_COFINS
                                                , PROD_TIPO_TRIBUTACAO_PIS_COFINS
                                                , PROD_FLAG_TRIB_PIS_COFINS_PROD 
                                                , PROD_LISTA_PROD        
                                                , NT_OP_CST             
                                                , CST_TP_TRIB_PIS        
                                                , CST_TP_TRIB_COFINS
												,PERC_DIFERIMENTO
												,VLR_DIFERIMENTO)
                 SELECT   
                        /**************** @TBL_TRIB_PROD **********************/
                        P.CD_ID                   
                        , P.CD_EMP                  
                        , P.CD_PROD                 
                        , P.CD_CTR                  
                        , P.CD_TRIB_CST             
                        , P.UF                      
                        , P.UF_FILIAL                 
                        , P.TP_MOV                  
                        , P.TP_TRANSA               
                        , P.TP_LISTA                
                        , P.DS_TP_LISTA                 
                        , P.NR_NCM                  
                        , P.NR_CEST                 
                        , P.CD_CLASS_FISC           
                        , P.DS_CLASS_FISC            
                        , P.PERC_RED                
                        , P.PERC_ICMS               
                        , P.TP_RED_BASE_IMP         
                        , P.PERC_RED_SUBS_TRIB      
                        , P.PERC_RED_ESTORNO        
                        , P.PERC_REPASSE            
                        , P.PERC_IBPT               
                        , P.TP_GERACAO_DARE         
                        , P.FLAG_TRIB_DARE             
                        , P.VLR_PAUTA_IVA           
                        , P.TP_SUBS                         
                        , P.DS_TP_SUBS                     
                        , P.PERC_ICMS_EST                
                        , P.PERC_ICMS_ORIGEM             
                        , P.HIST                         
                        , P.CD_TRIB                      
                        , P.CD_TRIB_FC                   
                        , P.ICMS                         
                        , P.SUBS_TRIB                    
                        , P.ICMS_RD                      
                        , P.SUBS_TRIB_ANT                
                        , P.ISENTO                       
                        , P.TIPO_REGIME_EMPRESA          
                        , P.FLAG_VLR_SUBST_TOTAL_PROD    
                        , P.FLAG_GERAR_ICMS_SUBS_DARE    
                        , P.FLAG_OUTROS                  
                        , P.ORIGEM_PRODUTO               
                        , P.DS_ORIGEM_PRODUTO             
                        , P.CD_TBL_MVA                   
                        , P.CD_REGIAO_FISCAL             
                        , P.NM_REGIAO_FISCAL             
                        , P.VLR_PAUTA_IVA_ORIGINAL         
                        , P.MVA_AJUSTADO
                        , P.TIPO_TRIBUTACAO_PIS_COFINS             
                        , P.SIGLA_EXCECAO_PIS_COFINS             
                        , P.FLAG_EXCECAO_PIS_COFINS                 
                        , P.PIS_COFINS                             
                        , P.FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP     
                        , P.FLAG_TRIB_PIS_COFINS_PROD             
                        , P.CTR_PMC                                 
                        , P.FLAG_GERAR_ICMS_RETIDO                 
                        , P.PERC_RED_IMPORTADO                   
                        , P.PERC_RED_SUBS_TRIB_IMPORTADO         
                        , P.TIPO_REGIME_EMPRESA_GRUPO_TRIB       
                        , P.DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB    
                        , P.TIPO_REGIME_DESTINATARIO_ORIGEM      
                        , P.DS_TIPO_REGIME_DESTINATARIO_ORIGEM   
                        , P.OBS_GRUPO_TRIB_NF                     
                        , P.EXCECAO_MVA_PRODUTO                     
                        , P.MODALI_BASE_ICMS_SUBST                 
                        , P.DS_MODALI_BASE_ICMS_SUBST             
                        , P.PRECO_BASE_SUBS                         
                        , P.PERC_REDU_PMC_FORN                   
                        , P.TIPO_REGIME_FILIAL                     
                        , P.DS_TIPO_REGIME_FILIAL                 
                        , P.TRIBUTACAO_FORNECEDOR                 
                        , P.VLR_PMC                                 
                        , P.VLR_ICMS_SUBS_GARANTIR                 
                        , P.PERC_ICMS_DESTINO_DIFAL                 
                        , P.PERC_ICMS_ORIGEM_DIFAL                 
                        , P.GERAR_DIFAL                             
                        , P.GERAR_DARE                             
                        , P.CONTRIBUINTE                         
                        , P.FLAG_GERAR_MOV_DARE                     
                        , P.GERAR_SUBS_TRIB                         
                        , P.TP_SUBS_TRIB                         
                        , P.PERC_ALIQ_FECOP                         
                        , P.FLAG_FRETE_BASE_ICMS                 
                        , P.FCOP                                 
                        , P.ICMS_DESONERADO                         
                        , P.MOTIVO_DESONERADO_ICMS                 
                        , P.VLR_ICMS_DESONERADO
                        , P.PERC_ICMS_DESONERADO
                        , P.CD_BENEF
                        /**************** UFD_EST_PROD_TRIB_TESTE_GERAR_IMPOSTO **********************/                 
                        , A.QT_PROD
                        , A.VLR_IT
                        , A.VLR_DESC_IT
                        , A.VLR_FRETE
                        , A.VLR_OUTROS
                        , A.VLR_IPI
                        , A.VLR_BASE_ICMS
                        , ISNULL(A.VLR_ICMS,0)
                        , A.VLR_BASE_SUBS
                        , A.VLR_ICMS_SUBS
                        , A.VLR_BASE_ICMS_OP
                        , A.VLR_ICMS_OP
                        , A.VLR_BASE_RET
                        , A.VLR_ICMS_RET
                        , A.VLR_CUSTO
                        , A.VLR_REA
                        , A.VLR_BASE_FCOP
                        , A.VLR_BASE_FCOP_SUBS
                        , A.VLR_BASE_FCOP_RET
                        , A.VLR_FCOP
                        , A.VLR_FCOP_SUBS
                        , A.VLR_FCOP_RET
                        /******************************** UFD_MONTAR_CFOP ****************************************/
                        , B.CD_NT_OP
                        , B.CD_NT_OP_FC                        
                        /******************************** UFD_EST_PROD_TRIB_TESTE_PIS_COFINS ****************************************/
                        , C.CD_CST_PIS
                        , C.PERC_PIS
                        , C.VLR_BASE_PIS
                        , C.VLR_PIS
                        , C.CD_CST_COFINS
                        , C.PERC_COFINS
                        , C.VLR_BASE_COFINS
                        , C.VLR_COFINS
                        , C.MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS
                        , C.PROD_PIS_COFINS
                        , C.PROD_TIPO_TRIBUTACAO
                        , C.PROD_FLAG_TRIB_PIS_COFINS_PROD
                        , C.PROD_LISTA_PROD
                        , C.NT_OP_CST
                        , C.CST_TP_TRIB_PIS
                        , C.CST_TP_TRIB_COFINS
                        , ISNULL(P.PERC_DIFERIMENTO,0)
					    , ISNULL(A.VLR_DIFERIMENTO,0)
                 FROM @TBL_TRIB_PROD P
                    OUTER APPLY UFD_EST_PROD_TRIB_GERAR_IMPOSTO(@QT_PROD, 
                                                                @VLR_IT,
                                                                @VLR_DESC_IT,
                                                                @VLR_FRETE,
                                                                @VLR_OUTRAS,
                                                                @VLR_PRODUTO_IPI,
                                                                PERC_ICMS,
                                                                PERC_ICMS_EST,
                                                                VLR_PMC,
                                                                VLR_PAUTA_IVA,
                                                                PERC_RED,
                                                                PERC_RED_SUBS_TRIB,
                                                                TP_SUBS,
                                                                CD_TRIB,
                                                                @PRECO_BASE_SUBS_DESCONTO,
                                                                @FLAG_GERAR_IMPOSTO_RETIDO,
                                                                PERC_ALIQ_FECOP,
																P.PERC_DIFERIMENTO) A
                    OUTER APPLY UFD_MONTAR_CFOP(@CD_EMP,@CD_FILIAL,@CD_MOV_OP,CD_TRIB,@CD_DEST_ORIG,0,0,@TIPO_OPERACAO)  B
                    OUTER APPLY UFD_EST_PROD_TRIB_PIS_COFINS(@CD_EMP,@CD_FILIAL,@CD_MOV_OP,CD_PROD,CD_NT_OP,@VLR_BASE_IMPOSTO,0) C
            END
        ELSE
            BEGIN
                INSERT INTO @RS_RETURN
                  (CD_ID
                                                , CD_EMP                            
                                                , CD_PROD                           
                                                , CD_CTR                            
                                                , CD_TRIB_CST                       
                                                , UF                                
                                                , UF_FILIAL                          
                                                , TP_MOV                            
                                                , TP_TRANSA                         
                                                , TP_LISTA                          
                                                , DS_TP_LISTA                          
                                                , NR_NCM                            
                                                , NR_CEST                           
                                                , CD_CLASS_FISC                     
                                                , DS_CLASS_FISC                      
                                                , PERC_RED                          
                                                , PERC_ICMS                         
                                                , TP_RED_BASE_IMP                   
                                                , PERC_RED_SUBS_TRIB                
                                                , PERC_RED_ESTORNO                  
                                                , PERC_REPASSE                      
                                                , PERC_IBPT                         
                                                , TP_GERACAO_DARE                   
                                                , FLAG_TRIB_DARE                    
                                                , VLR_PAUTA_IVA                     
                                                , TP_SUBS                           
                                                , DS_TP_SUBS                          
                                                , PERC_ICMS_EST                     
                                                , PERC_ICMS_ORIGEM                  
                                                , HIST                              
                                                , CD_TRIB                           
                                                , CD_TRIB_FC                        
                                                , ICMS                              
                                                , SUBS_TRIB                         
                                                , ICMS_RD                           
                                                , SUBS_TRIB_ANT                     
                                                , ISENTO                            
                                                , TIPO_REGIME_EMPRESA               
                                                , FLAG_VLR_SUBST_TOTAL_PROD          
                                                , FLAG_GERAR_ICMS_SUBS_DARE            
                                                , FLAG_OUTROS                       
                                                , ORIGEM_PRODUTO                    
                                                , DS_ORIGEM_PRODUTO                  
                                                , CD_TBL_MVA                        
                                                , CD_REGIAO_FISCAL                    
                                                , NM_REGIAO_FISCAL                    
                                                , VLR_PAUTA_IVA_ORIGINAL                
                                                , MVA_AJUSTADO                        
                                                , TIPO_TRIBUTACAO_PIS_COFINS            
                                                , SIGLA_EXCECAO_PIS_COFINS            
                                                , FLAG_EXCECAO_PIS_COFINS                
                                                , PIS_COFINS                            
                                                , FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP    
                                                , FLAG_TRIB_PIS_COFINS_PROD            
                                                , CTR_PMC                                
                                                , FLAG_GERAR_ICMS_RETIDO                
                                                , PERC_RED_IMPORTADO                  
                                                , PERC_RED_SUBS_TRIB_IMPORTADO        
                                                , TIPO_REGIME_EMPRESA_GRUPO_TRIB        
                                                , DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB   
                                                , TIPO_REGIME_DESTINATARIO_ORIGEM     
                                                , DS_TIPO_REGIME_DESTINATARIO_ORIGEM  
                                                , OBS_GRUPO_TRIB_NF                    
                                                , EXCECAO_MVA_PRODUTO                    
                                                , MODALI_BASE_ICMS_SUBST                
                                                , DS_MODALI_BASE_ICMS_SUBST            
                                                , PRECO_BASE_SUBS                        
                                                , PERC_REDU_PMC_FORN                  
                                                , TIPO_REGIME_FILIAL  
                                                , DS_TIPO_REGIME_FILIAL  
                                                , TRIBUTACAO_FORNECEDOR                
                                                , VLR_PMC                                
                                                , VLR_ICMS_SUBS_GARANTIR                
                                                , PERC_ICMS_DESTINO_DIFAL 
                                                , PERC_ICMS_ORIGEM_DIFAL     
                                                , GERAR_DIFAL                
                                                , GERAR_DAR                
                                                , CONTRIBUINTE            
                                                , FLAG_GERAR_MOV_DARE        
                                                , GERAR_SUBS_TRIB            
                                                , TP_SUBS_TRIB            
                                                , PERC_ALIQ_FECOP            
                                                , FLAG_FRETE_BASE_ICMS    
                                                , FCOP 
                                                , ICMS_DESONERADO  
                                                , MOTIVO_DESONERADO_ICMS   
                                                , VLR_ICMS_DESONERADO         
                                                , PERC_ICMS_DESONERADO    
                                                , CD_BENEF
                                                /**************** UFD_EST_PROD_TRIB_TESTE_GERAR_IMPOSTO **********************/          
                                                , QT_PROD 
                                                , VLR_IT  
                                                , VLR_DESC_IT  
                                                , VLR_FRETE  
                                                , VLR_OUTROS  
                                                , VLR_IPI  
                                                , VLR_BASE_ICMS  
                                                , VLR_ICMS   
                                                , VLR_BASE_SUBS  
                                                , VLR_ICMS_SUBS  
                                                , VLR_BASE_ICMS_OP  
                                                , VLR_ICMS_OP            
                                                , VLR_BASE_RET        
                                                , VLR_ICMS_RET        
                                                , VLR_CUSTO            
                                                , VLR_REA                
                                                , VLR_BASE_FECOP        
                                                , VLR_BASE_FECOP_SUBS        
                                                , VLR_BASE_FECOP_RET        
                                                , VLR_FECOP                
                                                , VLR_FECOP_ST            
                                                , VLR_FECOP_RET        
                                                /******************************** UFD_MONTAR_CFOP ****************************************/    
                                                , CD_NT_OP                
                                                , CD_NT_OP_FC    
                                                /******************************** UFD_EST_PROD_TRIB_TESTE_PIS_COFINS ****************************************/            
                                                , CST_PIS                    
                                                , PERC_PIS                
                                                , VLR_BASE_PIS            
                                                , VLR_PIS                    
                                                , CST_COFINS
                                                , PERC_COFINS
                                                , VLR_BASE_COFINS
                                                , VLR_COFINS
                                                , MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS 
                                                , PROD_PIS_COFINS
                                                , PROD_TIPO_TRIBUTACAO_PIS_COFINS
                                                , PROD_FLAG_TRIB_PIS_COFINS_PROD 
                                                , PROD_LISTA_PROD        
                                                , NT_OP_CST             
                                                , CST_TP_TRIB_PIS        
                                                , CST_TP_TRIB_COFINS
												, PERC_DIFERIMENTO
												,VLR_DIFERIMENTO)
                    SELECT   TOP 1
                        /**************** @TBL_TRIB_PROD **********************/
                        P.CD_ID                   
                        , P.CD_EMP                  
                        , P.CD_PROD                 
                        , P.CD_CTR                  
                        , P.CD_TRIB_CST             
                        , P.UF                      
                        , P.UF_FILIAL                 
                        , P.TP_MOV                  
                        , P.TP_TRANSA               
                        , P.TP_LISTA                
                        , P.DS_TP_LISTA                 
                        , P.NR_NCM                  
                        , P.NR_CEST                 
                        , P.CD_CLASS_FISC           
                        , P.DS_CLASS_FISC            
                        , P.PERC_RED                
                        , P.PERC_ICMS               
                        , P.TP_RED_BASE_IMP         
                        , P.PERC_RED_SUBS_TRIB      
                        , P.PERC_RED_ESTORNO        
                        , P.PERC_REPASSE            
                        , P.PERC_IBPT               
                        , P.TP_GERACAO_DARE         
                        , P.FLAG_TRIB_DARE             
                        , P.VLR_PAUTA_IVA           
                        , P.TP_SUBS                         
                        , P.DS_TP_SUBS                     
                        , P.PERC_ICMS_EST                
                        , P.PERC_ICMS_ORIGEM             
                        , P.HIST                         
                        , P.CD_TRIB                      
                        , P.CD_TRIB_FC                   
                        , P.ICMS                         
                        , P.SUBS_TRIB                    
                        , P.ICMS_RD                      
                        , P.SUBS_TRIB_ANT                
                        , P.ISENTO                       
                        , P.TIPO_REGIME_EMPRESA          
                        , P.FLAG_VLR_SUBST_TOTAL_PROD    
                        , P.FLAG_GERAR_ICMS_SUBS_DARE    
                        , P.FLAG_OUTROS                  
                        , P.ORIGEM_PRODUTO               
                        , P.DS_ORIGEM_PRODUTO             
                        , P.CD_TBL_MVA                   
                        , P.CD_REGIAO_FISCAL             
                        , P.NM_REGIAO_FISCAL             
                        , P.VLR_PAUTA_IVA_ORIGINAL         
                        , P.MVA_AJUSTADO
                        , P.TIPO_TRIBUTACAO_PIS_COFINS             
                        , P.SIGLA_EXCECAO_PIS_COFINS             
                        , P.FLAG_EXCECAO_PIS_COFINS                 
                        , P.PIS_COFINS                             
                        , P.FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP     
                        , P.FLAG_TRIB_PIS_COFINS_PROD             
                        , P.CTR_PMC                                 
                        , P.FLAG_GERAR_ICMS_RETIDO                 
                        , P.PERC_RED_IMPORTADO                   
                        , P.PERC_RED_SUBS_TRIB_IMPORTADO         
                        , P.TIPO_REGIME_EMPRESA_GRUPO_TRIB       
                        , P.DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB    
                        , P.TIPO_REGIME_DESTINATARIO_ORIGEM      
                        , P.DS_TIPO_REGIME_DESTINATARIO_ORIGEM   
                        , P.OBS_GRUPO_TRIB_NF                     
                        , P.EXCECAO_MVA_PRODUTO                     
                        , P.MODALI_BASE_ICMS_SUBST                 
                        , P.DS_MODALI_BASE_ICMS_SUBST             
                        , P.PRECO_BASE_SUBS                         
                        , P.PERC_REDU_PMC_FORN                   
                        , P.TIPO_REGIME_FILIAL                     
                        , P.DS_TIPO_REGIME_FILIAL                 
                        , P.TRIBUTACAO_FORNECEDOR                 
                        , P.VLR_PMC                                 
                        , P.VLR_ICMS_SUBS_GARANTIR                 
                        , P.PERC_ICMS_DESTINO_DIFAL                 
                        , P.PERC_ICMS_ORIGEM_DIFAL                 
                        , P.GERAR_DIFAL                             
                        , P.GERAR_DARE                             
                        , P.CONTRIBUINTE                         
                        , P.FLAG_GERAR_MOV_DARE                     
                        , P.GERAR_SUBS_TRIB                         
                        , P.TP_SUBS_TRIB                         
                        , P.PERC_ALIQ_FECOP                         
                        , P.FLAG_FRETE_BASE_ICMS                 
                        , P.FCOP                                 
                        , P.ICMS_DESONERADO                         
                        , P.MOTIVO_DESONERADO_ICMS                 
                        , P.VLR_ICMS_DESONERADO
                        , P.PERC_ICMS_DESONERADO
                        , P.CD_BENEF
                        /**************** UFD_EST_PROD_TRIB_TESTE_GERAR_IMPOSTO **********************/                 
                        , A.QT_PROD
                        , A.VLR_IT
                        , A.VLR_DESC_IT
                        , A.VLR_FRETE
                        , A.VLR_OUTROS
                        , A.VLR_IPI
                        , A.VLR_BASE_ICMS
                        , ISNULL(A.VLR_ICMS,0)
                        , A.VLR_BASE_SUBS
                        , A.VLR_ICMS_SUBS
                        , A.VLR_BASE_ICMS_OP
                        , A.VLR_ICMS_OP
                        , A.VLR_BASE_RET
                        , A.VLR_ICMS_RET
                        , A.VLR_CUSTO
                        , A.VLR_REA
                        , A.VLR_BASE_FCOP
                        , A.VLR_BASE_FCOP_SUBS
                        , A.VLR_BASE_FCOP_RET
                        , A.VLR_FCOP
                        , A.VLR_FCOP_SUBS
                        , A.VLR_FCOP_RET
                        /******************************** UFD_MONTAR_CFOP ****************************************/
                        , B.CD_NT_OP
                        , B.CD_NT_OP_FC                        
                        /******************************** UFD_EST_PROD_TRIB_TESTE_PIS_COFINS ****************************************/
                        , C.CD_CST_PIS
                        , C.PERC_PIS
                        , C.VLR_BASE_PIS
                        , C.VLR_PIS
                        , C.CD_CST_COFINS
                        , C.PERC_COFINS
                        , C.VLR_BASE_COFINS
                        , C.VLR_COFINS
                        , C.MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS
                        , C.PROD_PIS_COFINS
                        , C.PROD_TIPO_TRIBUTACAO
                        , C.PROD_FLAG_TRIB_PIS_COFINS_PROD
                        , C.PROD_LISTA_PROD
                        , C.NT_OP_CST
                        , C.CST_TP_TRIB_PIS
                        , C.CST_TP_TRIB_COFINS
						, ISNULL(P.PERC_DIFERIMENTO,0)
						, ISNULL(A.VLR_DIFERIMENTO,0)
                 FROM @TBL_TRIB_PROD P
                    OUTER APPLY UFD_EST_PROD_TRIB_GERAR_IMPOSTO(@QT_PROD, 
                                                                @VLR_IT,
                                                                @VLR_DESC_IT,
                                                                @VLR_FRETE,
                                                                @VLR_OUTRAS,
                                                                @VLR_PRODUTO_IPI,
                                                                PERC_ICMS,
                                                                PERC_ICMS_EST,
                                                                VLR_PMC,
                                                                VLR_PAUTA_IVA,
                                                                PERC_RED,
                                                                PERC_RED_SUBS_TRIB,
                                                                TP_SUBS,
                                                                CD_TRIB,
                                                                @PRECO_BASE_SUBS_DESCONTO,
                                                                @FLAG_GERAR_IMPOSTO_RETIDO,
                                                                PERC_ALIQ_FECOP,
																P.PERC_DIFERIMENTO) A
                    OUTER APPLY UFD_MONTAR_CFOP(@CD_EMP,@CD_FILIAL,@CD_MOV_OP,CD_TRIB,@CD_DEST_ORIG,0,0,@TIPO_OPERACAO)  B
                    OUTER APPLY UFD_EST_PROD_TRIB_PIS_COFINS(@CD_EMP,@CD_FILIAL,@CD_MOV_OP,CD_PROD,CD_NT_OP,@VLR_BASE_IMPOSTO,0) C
            END
-----------------------------------------------------------------------------------------------------------------------
--  C A L C U L O  D O  I C M S  D E S O N E R A D O
-----------------------------------------------------------------------------------------------------------------------
/*
VALOR DO ICMS DESONERADO = PRE?O NA NOTA FISCAL / (1 - AL?QUOTA) * AL?QUOTA 
*/
    IF EXISTS(SELECT * FROM @RS_RETURN WHERE ICMS_DESONERADO = 1)
    BEGIN 
		 UPDATE A
		    
           SET A.CD_BENEF = COALESCE(B.CD_BENEF, A.CD_BENEF, ''),
		       A.MOTIVO_DESONERADO_ICMS  =  COALESCE(B.MOTIVO_DESONERADO_ICMS, A.MOTIVO_DESONERADO_ICMS, 0) ,
			   A.ICMS_DESONERADO = CASE WHEN COALESCE(B.CD_BENEF, A.CD_BENEF, '') = '' THEN 0 ELSE 1 END,
			   A.PERC_ICMS_DESONERADO = CASE WHEN COALESCE(B.CD_BENEF, A.CD_BENEF, '') = '' THEN 0 ELSE A.PERC_ICMS_DESONERADO END
           FROM @RS_RETURN A 
                LEFT JOIN EST_PROD_COD_BENEF_TP_MOV B ON A.CD_PROD = B.CD_PROD AND A.UF_FILIAL = B.UF AND  RIGHT(A.CD_TRIB_FC,2) = RIGHT( B.CD_TRIB_FC ,2) AND A.TP_MOV = B.TP_MOV

         UPDATE @RS_RETURN 
         SET
            VLR_ICMS_DESONERADO = 
                CASE WHEN PERC_RED > 0 THEN 
                    --((VLR_IT - (VLR_IT * (PERC_RED/100.00))) * (PERC_ICMS_DESONERADO/100.00))
                    --VLR_IT * (1 - ((PERC_RED / 100) * (PERC_ICMS_DESONERADO))) / (1 - PERC_ICMS_DESONERADO) * PERC_ICMS_DESONERADO / 100 - 
                    VLR_IT *  (1 - ((PERC_RED / 100) * (PERC_ICMS_DESONERADO / 100))) / (1 - (PERC_ICMS_DESONERADO / 100)) * PERC_ICMS_DESONERADO / 100 - (VLR_IT * (PERC_RED / 100) * (PERC_ICMS_DESONERADO / 100)) 
                ELSE 
                    (VLR_IT / (1.00 - (PERC_ICMS_DESONERADO / 100.00))) * (PERC_ICMS_DESONERADO/100.00) 
                END
         WHERE ICMS_DESONERADO = 1    

        IF  @FLAG_NAO_ABATER_ICMS_DESONERADO =0
		BEGIN
			
			UPDATE @RS_RETURN
			SET
				VLR_CUSTO = VLR_CUSTO-VLR_ICMS_DESONERADO
		END

    END 

-----------------------------------------------------------------------------------------------------------------------
-- AJUSTANDO ICMS RETIDO 
    IF @FLAG_GERAR_ICMS_RETIDO_PARA_RESSARCIMENTO = 1
    BEGIN
        UPDATE
             R
         SET
            VLR_BASE_RET= COALESCE((CASE 
                                WHEN T.SUBS_TRIB=1 
                                    THEN ROUND((I.VLR_BASE_SUBS/I.QT_IT),2)
                                WHEN T.SUBS_TRIB_ANT=1 
                                    THEN ROUND((I.VLR_BASE_ICMS_RET/I.QT_IT),2)
                                ELSE 0
                            END), 0) *@QT_PROD,
            VLR_ICMS_RET = COALESCE((CASE WHEN T.SUBS_TRIB=1 THEN 
                ROUND((I.VLR_ICMS_SUBS/I.QT_IT),2)
              WHEN T.SUBS_TRIB_ANT=1 THEN
                ROUND((I.VLR_ICMS_RET/I.QT_IT),2)
             ELSE
                0
             END), 0) *@QT_PROD
          FROM
             @RS_RETURN R 
               --CAPTURAR A ULTIMA ENTRADA COM VALORES DE RETIDO OU SUBS--
             LEFT JOIN EST_NF_ENT_IT I ON 
              I.CD_EMP = @CD_EMP
                          AND I.CD_FILIAL  =@CD_FILIAL 
              AND I.CD_NF=(SELECT  
                           MAX( CD_NF)
                           FROM
                           EST_NF_ENT_IT  IX
                         INNER JOIN EST_TRIB TX ON
                           IX.CD_TRIB=TX.CD_TRIB  
                        WHERE
                          IX.CD_EMP = I.CD_EMP
                          AND IX.CD_FILIAL   =I.CD_FILIAL
                          AND IX.CD_PROD     =I.CD_PROD
                          AND( (IX.VLR_BASE_SUBS  > 0  AND TX.SUBS_TRIB=1)
                            OR (IX.VLR_BASE_ICMS_RET  > 0 AND TX.SUBS_TRIB_ANT=1)             
                          )  
                    )  
                 ---------------------------------------------------------   
                 AND I.CD_PROD   =@CD_PROD   
            INNER JOIN EST_TRIB T ON
                 I.CD_TRIB=T.CD_TRIB 
          WHERE
             I.CD_EMP=@CD_EMP AND
             I.CD_FILIAL=@CD_FILIAL
			  AND  R.SUBS_TRIB_ANT =1
    END

-----------------------------------------------------------------------------------------------------------------------
-- AJUSTANDO A EXCEO DE DIFAL
	IF @FLAG_NAO_GERAR_DIFAL = 1 
	BEGIN
		UPDATE
			@RS_RETURN
		SET
			PERC_ICMS_DESTINO_DIFAL  = 0,
			PERC_ICMS_ORIGEM_DIFAL	 = 0,
			GERAR_DIFAL				 = 0
	END

    RETURN
END
GO